/*
 * Decompiled with CFR 0.152.
 */
package jif;

import jif.ExtensionInfo;
import jif.FieldLabelInferenceGoal;
import jif.LabelCheckGoal;
import jif.TypeChecked;
import jif.ast.JifNodeFactory;
import jif.translate.JifToJavaRewriter;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.visit.IntegerBoundsChecker;
import jif.visit.JifInitChecker;
import jif.visit.NotNullChecker;
import jif.visit.PreciseClassChecker;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.JLExtensionInfo;
import polyglot.frontend.JLScheduler;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.frontend.Source;
import polyglot.frontend.goals.FieldConstantsChecked;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.VisitorGoal;
import polyglot.types.FieldInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ParsedTypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.NodeVisitor;

public class JifScheduler
extends JLScheduler {
    protected JLExtensionInfo jlext;
    protected Job objectJob = null;

    public JifScheduler(ExtensionInfo extInfo, JLExtensionInfo jlext) {
        super((polyglot.frontend.ExtensionInfo)extInfo);
        this.jlext = jlext;
    }

    public Goal LabelsChecked(Job job) {
        LabelCheckGoal g = (LabelCheckGoal)this.internGoal((Goal)new LabelCheckGoal(job));
        try {
            this.addPrerequisiteDependency((Goal)g, (Goal)this.FieldLabelInference(job));
            this.addPrerequisiteDependency((Goal)g, this.IntegerBoundsChecker(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public FieldLabelInferenceGoal FieldLabelInference(Job job) {
        FieldLabelInferenceGoal g = (FieldLabelInferenceGoal)this.internGoal((Goal)new FieldLabelInferenceGoal(job));
        try {
            this.addPrerequisiteDependency((Goal)g, this.ExceptionsChecked(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal IntegerBoundsChecker(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new IntegerBoundsChecker(job)));
        try {
            this.addPrerequisiteDependency(g, this.ReachabilityChecked(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal TypeChecked(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        Goal g = TypeChecked.create((Scheduler)this, job, ts, nf);
        return g;
    }

    public Goal PreciseClassChecker(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new PreciseClassChecker(job)));
        try {
            this.addPrerequisiteDependency(g, this.ReachabilityChecked(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal NotNullChecker(Job job) {
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new NotNullChecker(job)));
        try {
            this.addPrerequisiteDependency(g, this.ReachabilityChecked(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal ExceptionsChecked(Job job) {
        Goal g = super.ExceptionsChecked(job);
        try {
            this.addPrerequisiteDependency(g, this.NotNullChecker(job));
            this.addPrerequisiteDependency(g, this.PreciseClassChecker(job));
            this.addPrerequisiteDependency(g, this.IntegerBoundsChecker(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal JifToJavaRewritten(Job job) {
        JifTypeSystem ts = (JifTypeSystem)this.extInfo.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)this.extInfo.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new JifToJavaRewriter(job, ts, nf, (polyglot.frontend.ExtensionInfo)this.jlext)));
        try {
            this.addPrerequisiteDependency(g, this.Serialized(job));
            if (this.objectJob != null && job != this.objectJob) {
                this.addPrerequisiteDependency(g, this.JifToJavaRewritten(this.objectJob));
            }
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal Serialized(Job job) {
        Goal g = super.Serialized(job);
        try {
            this.addPrerequisiteDependency(g, this.LabelsChecked(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal FieldConstantsChecked(FieldInstance fi) {
        Goal g = this.internGoal((Goal)new JifFieldConstantsChecked(fi));
        try {
            if (fi.container() instanceof ParsedTypeObject) {
                ParsedTypeObject t = (ParsedTypeObject)fi.container();
                if (t.job() != null) {
                    this.addCorequisiteDependency(g, this.ConstantsChecked(t.job()));
                }
                if (t instanceof ParsedClassType) {
                    ParsedClassType ct = (ParsedClassType)t;
                    this.addPrerequisiteDependency(g, this.SignaturesResolved(ct));
                }
            }
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public Goal InitializationsChecked(Job job) {
        TypeSystem ts = this.extInfo.typeSystem();
        NodeFactory nf = this.extInfo.nodeFactory();
        Goal g = this.internGoal((Goal)new VisitorGoal(job, (NodeVisitor)new JifInitChecker(job, ts, nf)));
        try {
            this.addPrerequisiteDependency(g, this.ReachabilityChecked(job));
        }
        catch (CyclicDependencyException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return g;
    }

    public boolean runToCompletion() {
        if (super.runToCompletion()) {
            for (Job job : this.jlext.scheduler().jobs()) {
                this.jlext.scheduler().addGoal(this.jlext.getCompileGoal(job));
            }
            return this.jlext.scheduler().runToCompletion();
        }
        return false;
    }

    public Job addJob(Source source, Node ast) {
        Job j = super.addJob(source, ast);
        if ("Object.jif".equals(source.name())) {
            this.objectJob = j;
        }
        return j;
    }

    public Job addJob(Source source) {
        Job j = super.addJob(source);
        if ("Object.jif".equals(source.name())) {
            this.objectJob = j;
        }
        return j;
    }

    private static class JifFieldConstantsChecked
    extends FieldConstantsChecked {
        public JifFieldConstantsChecked(FieldInstance fi) {
            super(fi);
        }

        protected ParsedClassType findContainer() {
            JifSubstType jst;
            if (this.var().container() instanceof JifSubstType && (jst = (JifSubstType)this.var().container()).base() instanceof ParsedClassType) {
                return (ParsedClassType)jst.base();
            }
            return super.findContainer();
        }
    }
}

