/*
 * Decompiled with CFR 0.152.
 */
package jif;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jif.ExtensionInfo;
import polyglot.main.Options;
import polyglot.main.Report;
import polyglot.main.UsageError;

public class JifOptions
extends Options {
    public boolean nonRobustness;
    public boolean solveGlobally;
    public boolean explainErrors;
    public String sigcp = null;
    public List addSigcp = new ArrayList();

    public JifOptions(ExtensionInfo extension) {
        super((polyglot.frontend.ExtensionInfo)extension);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        super.setDefaultValues();
        this.solveGlobally = false;
        this.explainErrors = false;
        this.nonRobustness = false;
    }

    protected int parseCommand(String[] args, int index, Set source) throws UsageError {
        if (args[index].equals("-globalsolve")) {
            ++index;
            System.err.println("Will use a single solver to infer labels");
            this.solveGlobally = true;
        } else if (args[index].equals("-explain") || args[index].equals("-e")) {
            ++index;
            this.explainErrors = true;
        } else if (args[index].equals("-nonrobust")) {
            ++index;
            this.nonRobustness = true;
        } else if (args[index].equals("-robust")) {
            ++index;
            this.nonRobustness = false;
        } else if (args[index].equals("-sigcp")) {
            int n = ++index;
            ++index;
            this.sigcp = args[n];
        } else if (args[index].equals("-addsigcp")) {
            int n = ++index;
            ++index;
            this.addSigcp.add(args[n]);
        } else if (args[index].equals("-debug")) {
            ++index;
            int level = 0;
            try {
                level = Integer.parseInt(args[index]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Report.addTopic((String)"debug", (int)level);
            ++index;
        } else {
            int i = super.parseCommand(args, index, source);
            return i;
        }
        return index;
    }

    public void usage(PrintStream out) {
        super.usage(out);
        this.usageForFlag(out, "-e -explain", "provide more detailed explanations of failed label checking.");
        this.usageForFlag(out, "-robust", "enable checking of robustness conditions for downgrading (use -nonrobust to disable).");
        this.usageForFlag(out, "-debug <n>", "set debug level to n. Prints more information about labels.");
        this.usageForFlag(out, "-stop_constraint <n>", "halt when the nth constraint is added");
        this.usageForFlag(out, "-globalsolve", "infer label variables globally (default: per class)");
        this.usageForFlag(out, "-sigcp <path>", "path for Jif signatures (e.g. for java.lang.Object)");
        this.usageForFlag(out, "-addsigcp <path>", "additional path for Jif signatures; prepended to sigcp");
    }

    public String constructSignatureClasspath() {
        String scp = "";
        Iterator iter = this.addSigcp.iterator();
        while (iter.hasNext()) {
            scp = scp + (String)iter.next();
            if (!iter.hasNext()) continue;
            scp = scp + File.pathSeparator;
        }
        if (this.sigcp != null) {
            scp = scp + File.pathSeparator + this.sigcp;
        }
        return scp;
    }

    public String constructJifClasspath() {
        return this.constructSignatureClasspath() + File.pathSeparator + this.constructFullClasspath();
    }

    public String constructOutputExtClasspath() {
        return this.constructFullClasspath();
    }

    public String constructPostCompilerClasspath() {
        String cp = super.constructPostCompilerClasspath() + File.pathSeparator + this.constructFullClasspath();
        return cp;
    }
}

