/*
 * Decompiled with CFR 0.152.
 */
package jif.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import jif.lang.ConfPolicy;
import jif.lang.IntegPolicy;
import jif.lang.Label;
import jif.lang.LabelUtil;
import jif.lang.Principal;
import jif.lang.PrincipalUtil;
import jif.runtime.FileSystem;
import jif.runtime.NativePrincipal;

public class Runtime {
    private Principal dynp;
    private static boolean _nativeOK = true;

    private Runtime(Principal p) {
        this.dynp = p;
    }

    public static Runtime getRuntime(Principal p) throws SecurityException {
        Principal user = Runtime.user(p);
        if (!PrincipalUtil.actsFor(user, p)) {
            throw new SecurityException("The current user does not act for " + p.name() + ".");
        }
        return new Runtime(p);
    }

    public static Principal user(Principal parameter) {
        String username = Runtime.currentUser();
        return NativePrincipal.getInstance(username);
    }

    public static Principal getUser(Principal parameter, String username) {
        return NativePrincipal.getInstance(username);
    }

    private Label defaultOutputLabel() {
        ConfPolicy cp = LabelUtil.singleton().readerPolicy(this.dynp, new LinkedList<Principal>());
        return LabelUtil.singleton().toLabel(cp);
    }

    private Label defaultInputLabel() {
        IntegPolicy ip = LabelUtil.singleton().writerPolicy(this.dynp, new LinkedList<Principal>());
        return LabelUtil.singleton().toLabel(ip);
    }

    public FileOutputStream openFileWrite(String name, boolean append, Label L) throws IOException, SecurityException {
        File f = new File(name);
        boolean existed = f.exists();
        if (existed) {
            Label acLabel = FileSystem.labelOf(name);
            if (!LabelUtil.singleton().relabelsTo(L, acLabel)) {
                throw new SecurityException("The file " + name + "doesn't have sufficient access restrictions.");
            }
        }
        FileOutputStream fos = new FileOutputStream(name, append);
        if (!existed) {
            fos.flush();
        }
        return fos;
    }

    public FileInputStream openFileRead(String name, Label L) throws FileNotFoundException, SecurityException {
        Label acLabel = FileSystem.labelOf(name);
        if (LabelUtil.singleton().relabelsTo(acLabel, L)) {
            return new FileInputStream(name);
        }
        throw new SecurityException("The file has label " + LabelUtil.singleton().stringValue(acLabel) + ", which is more restrictive than " + L.toString());
    }

    public PrintStream stderr(Label l) {
        if (LabelUtil.singleton().relabelsTo(l, this.defaultOutputLabel())) {
            return System.err;
        }
        throw new SecurityException("The standard error output is not sufficiently secure.");
    }

    public PrintStream stdout(Label l) {
        if (LabelUtil.singleton().relabelsTo(l, this.defaultOutputLabel())) {
            return System.out;
        }
        throw new SecurityException("The standard output is not sufficiently secure.");
    }

    public InputStream stdin(Label l) {
        if (LabelUtil.singleton().relabelsTo(this.defaultInputLabel(), l)) {
            return System.in;
        }
        throw new SecurityException("The standard output is not sufficiently secure.");
    }

    public PrintStream out() {
        return System.out;
    }

    public InputStream in() {
        return System.in;
    }

    public PrintStream err() {
        return System.err;
    }

    public static String currentUser() {
        if (_nativeOK) {
            return Runtime.currentUserImpl();
        }
        return null;
    }

    private static native String currentUserImpl();

    public static int currentYear(Principal dummy) {
        return new GregorianCalendar().get(1);
    }

    public static int currentMonth(Principal dummy) {
        return new GregorianCalendar().get(2) - 0 + 1;
    }

    public static int currentDayOfMonth(Principal dummy) {
        return new GregorianCalendar().get(5);
    }

    public static int currentHour(Principal dummy) {
        return new GregorianCalendar().get(11);
    }

    public static int currentMinute(Principal dummy) {
        return new GregorianCalendar().get(12);
    }

    public static void sleep(Principal dummy, int s) {
        try {
            double noise = 0.15;
            double multiplier = 1.0 + (2.0 * Math.random() - 1.0) * noise;
            long ms = (long)((double)((long)s * 1000L) * multiplier);
            if (!Thread.interrupted()) {
                Thread.sleep(ms);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Object[] arrayDeepClone(Object[] a) {
        if (a == null) {
            return null;
        }
        Object[] c = (Object[])a.clone();
        for (int i = 0; i < a.length; ++i) {
            Object o = a[i];
            if (o != null && o.getClass().isArray()) {
                if (o.getClass().getComponentType().isPrimitive()) {
                    int length = Array.getLength(o);
                    o = Array.newInstance(o.getClass().getComponentType(), length);
                    System.arraycopy(a[i], 0, o, 0, length);
                } else {
                    o = Runtime.arrayDeepClone(o);
                }
            }
            c[i] = o;
        }
        return c;
    }

    static {
        try {
            System.loadLibrary("jifrt");
        }
        catch (UnsatisfiedLinkError ule) {
            _nativeOK = false;
        }
    }
}

