/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jif.lang.ActsForProof;
import jif.lang.Capability;
import jif.lang.Closure;
import jif.lang.ConfPolicy;
import jif.lang.ConjunctivePrincipal;
import jif.lang.DelegatesProof;
import jif.lang.DisjunctivePrincipal;
import jif.lang.FromDisjunctProof;
import jif.lang.IntegPolicy;
import jif.lang.Label;
import jif.lang.LabelUtil;
import jif.lang.Principal;
import jif.lang.ReaderPolicy;
import jif.lang.ReflexiveProof;
import jif.lang.ToConjunctProof;
import jif.lang.TransitiveProof;
import jif.lang.WriterPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalUtil {
    private static Principal TOP_PRINCIPAL = new TopPrincipal();
    private static final Map<ActsForPair, ActsForProof> cacheActsFor = new ConcurrentHashMap<ActsForPair, ActsForProof>();
    private static final Map<ActsForPair, ActsForPair> cacheNotActsFor = new ConcurrentHashMap<ActsForPair, ActsForPair>();
    private static final Map<DelegationPair, Set<ActsForPair>> cacheActsForDependencies = new ConcurrentHashMap<DelegationPair, Set<ActsForPair>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acts_for(Principal p, Principal q) {
        try {
            LabelUtil.singleton().enterTiming();
            boolean bl = PrincipalUtil.actsFor(p, q);
            return bl;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    public static boolean actsFor(Principal p, Principal q) {
        return PrincipalUtil.actsForProof(p, q) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActsForProof actsForProof(Principal p, Principal q) {
        try {
            LabelUtil.singleton().enterTiming();
            ActsForPair pair = new ActsForPair(p, q);
            if (cacheActsFor.containsKey(pair)) {
                ActsForProof actsForProof = cacheActsFor.get(pair);
                return actsForProof;
            }
            if (cacheNotActsFor.containsKey(pair)) {
                ActsForProof actsForProof = null;
                return actsForProof;
            }
            if (PrincipalUtil.delegatesTo(q, p)) {
                DelegatesProof delegatesProof = new DelegatesProof(p, q);
                return delegatesProof;
            }
            if (PrincipalUtil.eq(p, q)) {
                ReflexiveProof reflexiveProof = new ReflexiveProof(p, q);
                return reflexiveProof;
            }
            ActsForProof prf = PrincipalUtil.findActsForProof(p, q, null);
            if (prf != null && PrincipalUtil.verifyProof(prf, p, q)) {
                cacheActsFor.put(pair, prf);
                HashSet s = new HashSet();
                prf.gatherDelegationDependencies(s);
                for (DelegationPair del : s) {
                    Set<ActsForPair> deps = cacheActsForDependencies.get(del);
                    if (deps == null) {
                        deps = new HashSet<ActsForPair>();
                        cacheActsForDependencies.put(del, deps);
                    }
                    deps.add(pair);
                }
                ActsForProof actsForProof = prf;
                return actsForProof;
            }
            cacheNotActsFor.put(pair, pair);
            ActsForProof actsForProof = null;
            return actsForProof;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    public static void notifyNewDelegation(Principal granter, Principal superior) {
        if (!PrincipalUtil.delegatesTo(granter, superior)) {
            return;
        }
        cacheNotActsFor.clear();
        LabelUtil.singleton().notifyNewDelegation(granter, superior);
    }

    public static void notifyRevokeDelegation(Principal granter, Principal superior) {
        DelegationPair del = new DelegationPair(superior, granter);
        Set<ActsForPair> deps = cacheActsForDependencies.remove(del);
        if (deps != null) {
            for (ActsForPair afp : deps) {
                cacheActsFor.remove(afp);
            }
        }
        LabelUtil.singleton().notifyRevokeDelegation(granter, superior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActsForProof findActsForProof(Principal p, Principal q, Object searchState) {
        try {
            ActsForProof prf;
            ProofSearchState newss;
            LabelUtil.singleton().enterTiming();
            if (q == null) {
                DelegatesProof delegatesProof = new DelegatesProof(p, q);
                return delegatesProof;
            }
            if (PrincipalUtil.eq(p, q)) {
                ReflexiveProof reflexiveProof = new ReflexiveProof(p, q);
                return reflexiveProof;
            }
            if (searchState instanceof ProofSearchState) {
                ProofSearchState ss = (ProofSearchState)searchState;
                if (ss.contains(p, q)) {
                    ActsForProof actsForProof = null;
                    return actsForProof;
                }
                newss = new ProofSearchState(ss, p, q);
            } else {
                newss = new ProofSearchState(p, q);
            }
            boolean doneDownTo = false;
            if (p instanceof ConjunctivePrincipal || p instanceof DisjunctivePrincipal) {
                prf = p.findProofDownto(q, newss);
                if (prf != null) {
                    ActsForProof actsForProof = prf;
                    return actsForProof;
                }
                doneDownTo = true;
            }
            if ((prf = q.findProofUpto(p, newss)) != null) {
                ActsForProof actsForProof = prf;
                return actsForProof;
            }
            if (!doneDownTo && p != null && (prf = p.findProofDownto(q, newss)) != null) {
                ActsForProof actsForProof = prf;
                return actsForProof;
            }
            ActsForProof actsForProof = null;
            return actsForProof;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    private static boolean eq(Principal p, Principal q) {
        return p == q || p != null && q != null && p.equals(q) && q.equals(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyProof(ActsForProof prf, Principal actor, Principal granter) {
        try {
            ActsForProof proof;
            LabelUtil.singleton().enterTiming();
            if (prf == null) {
                boolean bl = false;
                return bl;
            }
            if (prf.getActor() != actor || prf.getGranter() != granter) {
                boolean bl = false;
                return bl;
            }
            if (prf instanceof DelegatesProof) {
                boolean bl = PrincipalUtil.delegatesTo(granter, actor);
                return bl;
            }
            if (prf instanceof ReflexiveProof) {
                boolean bl = PrincipalUtil.eq(actor, granter);
                return bl;
            }
            if (prf instanceof TransitiveProof) {
                TransitiveProof proof2 = (TransitiveProof)prf;
                boolean bl = PrincipalUtil.verifyProof(proof2.getActorToP(), proof2.getActor(), proof2.getP()) && PrincipalUtil.verifyProof(proof2.getPToGranter(), proof2.getP(), proof2.getGranter());
                return bl;
            }
            if (prf instanceof FromDisjunctProof) {
                proof = (FromDisjunctProof)prf;
                if (actor instanceof DisjunctivePrincipal) {
                    DisjunctivePrincipal dp = (DisjunctivePrincipal)actor;
                    for (Principal disjunct : dp.disjuncts) {
                        ActsForProof pr = (ActsForProof)((FromDisjunctProof)proof).getDisjunctProofs().get(disjunct);
                        if (PrincipalUtil.verifyProof(pr, disjunct, granter)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean iter = true;
                    return iter;
                }
            } else if (prf instanceof ToConjunctProof) {
                proof = (ToConjunctProof)prf;
                if (granter instanceof ConjunctivePrincipal) {
                    ConjunctivePrincipal cp = (ConjunctivePrincipal)granter;
                    for (Principal conjunct : cp.conjuncts) {
                        ActsForProof pr = (ActsForProof)((ToConjunctProof)proof).getConjunctProofs().get(conjunct);
                        if (PrincipalUtil.verifyProof(pr, actor, conjunct)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delegatesTo(Principal granter, Principal superior) {
        try {
            LabelUtil.singleton().enterTiming();
            if (granter == null) {
                boolean bl = true;
                return bl;
            }
            if (PrincipalUtil.topPrincipal().equals(superior)) {
                boolean bl = true;
                return bl;
            }
            if (superior instanceof ConjunctivePrincipal) {
                ConjunctivePrincipal cp = (ConjunctivePrincipal)superior;
                for (Principal conjunct : cp.conjuncts) {
                    if (!PrincipalUtil.equals(conjunct, granter)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = granter.delegatesTo(superior);
            return bl;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equivalentTo(Principal p, Principal q) {
        try {
            LabelUtil.singleton().enterTiming();
            boolean bl = PrincipalUtil.actsFor(p, q) && PrincipalUtil.actsFor(q, p);
            return bl;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(Principal p, Principal q) {
        try {
            LabelUtil.singleton().enterTiming();
            boolean bl = PrincipalUtil.eq(p, q);
            return bl;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    public static Object execute(Principal p, Object authPrf, Closure c, Label lb) {
        Capability cap = PrincipalUtil.authorize(p, authPrf, c, lb, true);
        if (cap != null) {
            return cap.invoke();
        }
        return null;
    }

    public static Capability authorize(Principal p, Object authPrf, Closure c, Label lb) {
        return PrincipalUtil.authorize(p, authPrf, c, lb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Capability authorize(Principal p, Object authPrf, Closure c, Label lb, boolean executeNow) {
        try {
            LabelUtil.singleton().enterTiming();
            Principal closureP = c.jif$getjif_lang_Closure_P();
            Label closureL = c.jif$getjif_lang_Closure_L();
            if ((closureP == p || p != null && closureP != null && p.equals(closureP) && closureP.equals(p)) && LabelUtil.singleton().equivalentTo(closureL, lb) && (p == null || p.isAuthorized(authPrf, c, lb, executeNow))) {
                Capability capability = new Capability(closureP, closureL, c);
                return capability;
            }
            Capability capability = null;
            return capability;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    public static Principal nullPrincipal() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal bottomPrincipal() {
        try {
            LabelUtil.singleton().enterTiming();
            Principal principal = PrincipalUtil.nullPrincipal();
            return principal;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    public static Principal topPrincipal() {
        return TOP_PRINCIPAL;
    }

    static boolean isTopPrincipal(Principal p) {
        return p == TOP_PRINCIPAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfPolicy readableByPrinPolicy(Principal p) {
        try {
            LabelUtil.singleton().enterTiming();
            ReaderPolicy readerPolicy = new ReaderPolicy(LabelUtil.singleton(), PrincipalUtil.topPrincipal(), p);
            return readerPolicy;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntegPolicy writableByPrinPolicy(Principal p) {
        try {
            LabelUtil.singleton().enterTiming();
            WriterPolicy writerPolicy = new WriterPolicy(LabelUtil.singleton(), PrincipalUtil.topPrincipal(), p);
            return writerPolicy;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal disjunction(Principal left, Principal right) {
        try {
            LabelUtil.singleton().enterTiming();
            if (left == null || right == null) {
                Principal principal = null;
                return principal;
            }
            if (PrincipalUtil.actsFor(left, right)) {
                Principal principal = right;
                return principal;
            }
            if (PrincipalUtil.actsFor(right, left)) {
                Principal principal = left;
                return principal;
            }
            ArrayList<Principal> c = new ArrayList<Principal>(2);
            c.add(left);
            c.add(right);
            Principal principal = PrincipalUtil.disjunction(c);
            return principal;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal conjunction(Principal left, Principal right) {
        try {
            LabelUtil.singleton().enterTiming();
            if (left == null) {
                Principal principal = right;
                return principal;
            }
            if (right == null) {
                Principal principal = left;
                return principal;
            }
            if (PrincipalUtil.actsFor(left, right)) {
                Principal principal = left;
                return principal;
            }
            if (PrincipalUtil.actsFor(right, left)) {
                Principal principal = right;
                return principal;
            }
            ArrayList<Principal> c = new ArrayList<Principal>(2);
            c.add(left);
            c.add(right);
            Principal principal = PrincipalUtil.conjunction(c);
            return principal;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal disjunction(Collection<Principal> principals) {
        try {
            LabelUtil.singleton().enterTiming();
            if (principals == null || principals.isEmpty()) {
                Principal principal = PrincipalUtil.topPrincipal();
                return principal;
            }
            if (principals.size() == 1) {
                Principal o = principals.iterator().next();
                if (o == null || o instanceof Principal) {
                    Principal principal = o;
                    return principal;
                }
                Principal principal = PrincipalUtil.topPrincipal();
                return principal;
            }
            LinkedHashSet<Principal> needed = new LinkedHashSet<Principal>();
            for (Principal o : principals) {
                Principal p = null;
                if (o instanceof Principal) {
                    p = o;
                }
                if (p == null) {
                    Principal principal = p;
                    return principal;
                }
                if (PrincipalUtil.isTopPrincipal(p)) continue;
                if (p instanceof DisjunctivePrincipal) {
                    needed.addAll(((DisjunctivePrincipal)p).disjuncts);
                    continue;
                }
                needed.add(p);
            }
            DisjunctivePrincipal disjunctivePrincipal = new DisjunctivePrincipal(needed);
            return disjunctivePrincipal;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal conjunction(Collection<Principal> principals) {
        try {
            LabelUtil.singleton().enterTiming();
            if (principals == null || principals.isEmpty()) {
                Principal principal = PrincipalUtil.bottomPrincipal();
                return principal;
            }
            if (principals.size() == 1) {
                Principal o = principals.iterator().next();
                if (o == null || o instanceof Principal) {
                    Principal principal = o;
                    return principal;
                }
                Principal principal = PrincipalUtil.bottomPrincipal();
                return principal;
            }
            LinkedHashSet<Principal> needed = new LinkedHashSet<Principal>();
            for (Principal o : principals) {
                Principal p = null;
                if (o instanceof Principal) {
                    p = o;
                }
                if (p == null) continue;
                if (PrincipalUtil.isTopPrincipal(p)) {
                    Principal principal = p;
                    return principal;
                }
                if (p instanceof ConjunctivePrincipal) {
                    needed.addAll(((ConjunctivePrincipal)p).conjuncts);
                    continue;
                }
                needed.add(p);
            }
            ConjunctivePrincipal conjunctivePrincipal = new ConjunctivePrincipal(needed);
            return conjunctivePrincipal;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Principal p) {
        try {
            LabelUtil.singleton().enterTiming();
            String string = p == null ? "_" : p.name();
            return string;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringValue(Principal p) {
        try {
            LabelUtil.singleton().enterTiming();
            String string = PrincipalUtil.toString(p);
            return string;
        }
        finally {
            LabelUtil.singleton().exitTiming();
        }
    }

    static class DelegationPair
    extends PrincipalPair {
        DelegationPair(Principal actor, Principal granter) {
            super(actor, granter);
        }
    }

    private static class ActsForPair
    extends PrincipalPair {
        ActsForPair(Principal superior, Principal inferior) {
            super(superior, inferior);
        }
    }

    private static abstract class PrincipalPair {
        final Principal p;
        final Principal q;

        PrincipalPair(Principal p, Principal q) {
            this.p = p;
            this.q = q;
        }

        public boolean equals(Object o) {
            if (o != null && o.getClass().equals(this.getClass())) {
                PrincipalPair that = (PrincipalPair)o;
                return PrincipalUtil.eq(this.p, that.p) && PrincipalUtil.eq(this.q, that.q);
            }
            return false;
        }

        public int hashCode() {
            return (this.p == null ? -4234 : this.p.hashCode()) ^ (this.q == null ? 23 : this.q.hashCode());
        }

        public String toString() {
            return this.p.name() + "-" + this.q.name();
        }
    }

    private static final class TopPrincipal
    implements Principal {
        private TopPrincipal() {
        }

        public String name() {
            return "*";
        }

        public boolean delegatesTo(Principal p) {
            return false;
        }

        public boolean equals(Principal p) {
            return p == this;
        }

        public boolean isAuthorized(Object authPrf, Closure closure, Label lb, boolean executeNow) {
            return false;
        }

        public ActsForProof findProofUpto(Principal p, Object searchState) {
            return null;
        }

        public ActsForProof findProofDownto(Principal q, Object searchState) {
            return null;
        }
    }

    private static class ProofSearchState {
        private ActsForPair[] goalstack;

        public ProofSearchState(Principal p, Principal q) {
            this.goalstack = new ActsForPair[1];
            this.goalstack[0] = new ActsForPair(p, q);
        }

        private ProofSearchState(ProofSearchState ss, Principal p, Principal q) {
            int len = ss.goalstack.length + 1;
            this.goalstack = new ActsForPair[len];
            System.arraycopy(ss.goalstack, 0, this.goalstack, 0, len - 1);
            this.goalstack[len - 1] = new ActsForPair(p, q);
        }

        public boolean contains(Principal p, Principal q) {
            for (int i = 0; i < this.goalstack.length; ++i) {
                if (this.goalstack[i] == null || !PrincipalUtil.eq(this.goalstack[i].p, p) || !PrincipalUtil.eq(this.goalstack[i].q, q)) continue;
                return true;
            }
            return false;
        }
    }
}

