/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jif.lang.AbstractPolicy;
import jif.lang.JoinPolicy;
import jif.lang.LabelUtil;
import jif.lang.Policy;
import jif.lang.PrincipalUtil;

public abstract class MeetPolicy
extends AbstractPolicy
implements Policy {
    private Set components;

    MeetPolicy(LabelUtil labelUtil, Set policies) {
        super(labelUtil);
        this.components = Collections.unmodifiableSet(policies);
    }

    public Set meetComponents() {
        return this.components;
    }

    public boolean relabelsTo(Policy pol, Set s) {
        if (this == pol || this.equals(pol)) {
            return true;
        }
        for (Policy Ci : this.components) {
            if (!this.labelUtil.relabelsTo(Ci, pol, s)) continue;
            return true;
        }
        if (pol instanceof MeetPolicy) {
            MeetPolicy mp = (MeetPolicy)pol;
            boolean sat = true;
            HashSet<PrincipalUtil.DelegationPair> temp = new HashSet<PrincipalUtil.DelegationPair>();
            for (Policy Di : mp.meetComponents()) {
                if (this.labelUtil.relabelsTo(this, Di, temp)) continue;
                sat = false;
                break;
            }
            if (sat) {
                s.addAll(temp);
                return true;
            }
        }
        if (pol instanceof JoinPolicy) {
            JoinPolicy jp = (JoinPolicy)pol;
            for (Policy Di : jp.joinComponents()) {
                if (!this.labelUtil.relabelsTo(this, Di, s)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof MeetPolicy) {
            MeetPolicy that = (MeetPolicy)o;
            return this == that || ((Object)this.meetComponents()).equals(that.meetComponents());
        }
        return false;
    }

    public final int hashCode() {
        return ((Object)this.components).hashCode();
    }

    public final String toString() {
        String str = "";
        Iterator iter = this.components.iterator();
        while (iter.hasNext()) {
            str = str + ((Policy)iter.next()).toString();
            if (!iter.hasNext()) continue;
            str = str + " meet ";
        }
        return str;
    }
}

