/*
 * Decompiled with CFR 0.152.
 */
package jif.lang;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import jif.lang.ActsForProof;
import jif.lang.Closure;
import jif.lang.DelegatesProof;
import jif.lang.Label;
import jif.lang.Principal;
import jif.lang.PrincipalUtil;
import jif.lang.ToConjunctProof;
import jif.lang.TransitiveProof;

public final class ConjunctivePrincipal
implements Principal {
    final Set conjuncts;
    private Integer hashCode;

    ConjunctivePrincipal(Set conjuncts) {
        this.conjuncts = conjuncts;
    }

    public String name() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.conjuncts.iterator();
        while (iter.hasNext()) {
            Principal p = (Principal)iter.next();
            sb.append(PrincipalUtil.toString(p));
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public boolean delegatesTo(Principal p) {
        if (p instanceof ConjunctivePrincipal) {
            ConjunctivePrincipal cp = (ConjunctivePrincipal)p;
            return cp.conjuncts.containsAll(this.conjuncts);
        }
        for (Principal q : this.conjuncts) {
            if (PrincipalUtil.delegatesTo(q, p)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = new Integer(((Object)this.conjuncts).hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Principal p) {
        if (p instanceof ConjunctivePrincipal) {
            ConjunctivePrincipal that = (ConjunctivePrincipal)p;
            return this.hashCode() == that.hashCode() && ((Object)this.conjuncts).equals(that.conjuncts) && ((Object)that.conjuncts).equals(this.conjuncts);
        }
        return false;
    }

    public boolean isAuthorized(Object authPrf, Closure closure, Label lb, boolean executeNow) {
        for (Principal p : this.conjuncts) {
            if (p.isAuthorized(authPrf, closure, lb, executeNow)) continue;
            return false;
        }
        return true;
    }

    public ActsForProof findProofUpto(Principal p, Object searchState) {
        HashMap<Principal, ActsForProof> proofs = new HashMap<Principal, ActsForProof>();
        for (Principal q : this.conjuncts) {
            ActsForProof prf = PrincipalUtil.findActsForProof(p, q, searchState);
            if (prf == null) {
                return null;
            }
            proofs.put(q, prf);
        }
        return new ToConjunctProof(p, this, proofs);
    }

    public ActsForProof findProofDownto(Principal q, Object searchState) {
        for (Principal witness : this.conjuncts) {
            ActsForProof prf = PrincipalUtil.findActsForProof(witness, q, searchState);
            if (prf == null) continue;
            DelegatesProof step = new DelegatesProof(this, witness);
            return new TransitiveProof(step, witness, prf);
        }
        return null;
    }
}

