#include <iostream>
#include <string>
#include <unordered_set>
using namespace std;

/******************************************************************************
 * This is a hard problem to code, but it's simply about following
 * instructions and keeping track of what was the last message, and the last
 * message Dudu typed (not counting "I demand repectation")
 *****************************************************************************/

string get_user(const string& message) {
    return message.substr(0, message.find(':'));
}

int main() {
    unordered_set<string> users_seen;
    string last_dudu, last_message;

    int N, K;
    // ws at the end makes sure that the \n at the end of the first line will be consumed
    cin >> N >> K >> ws;
    while (N--) {
        string message;
        getline(cin, message);
        string user = get_user(message);
        if (users_seen.find(user) == users_seen.end()) {
            // first time this user sends a message
            cout << user << " sees\n";
            if (last_message.size() != 0)
                cout << last_message << "\n";
            cout << "\n";
            users_seen.insert(user);
        }

        if (message == "Dudu: I demand respectation") {
            last_message = last_dudu;
        } else {
            last_message = message;
            if (user == "Dudu") last_dudu = message;
        }
    }
    return 0;
}
