#include <cstdio>

/******************************************************************************
 * For the small version of the problem we can "try all triangles". Since each
 * vertex can only be in ~400 different positions, the number of different
 * triangles is ~400^3 == 64000000 == 64 million, which is small enough for
 * the time limit of a few seconds.
 *
 * We will use the fact that there are no equilateral triangles with integer
 * coefficients (try to prove why, it has to do with sqrt(3) being irrational).
 *****************************************************************************/

int main() {
    int n, m;
    scanf("%d %d", &n, &m);
    int ans = 0;
    for (int x1 = 0; x1 <= n; x1++)
    for (int y1 = 0; y1 <= m; y1++)
    for (int x2 = 0; x2 <= n; x2++)
    for (int y2 = 0; y2 <= m; y2++)
    for (int x3 = 0; x3 <= n; x3++)
    for (int y3 = 0; y3 <= m; y3++) {
        // To break symmetry we only count a match if the distance P1-P2 is
        // equal to P1-P3 (P1 is the vertex that connects the two sides with the
        // same length.

        int d12 = (x1-x2)*(x1-x2) + (y1-y2)*(y1-y2);
        int d13 = (x1-x3)*(x1-x3) + (y1-y3)*(y1-y3);
        int d23 = (x2-x3)*(x2-x3) + (y2-y3)*(y2-y3);

        if (d12 == 0 || d13 == 0 || d23 == 0) continue; // two points at the same place
        if (d12 != d13) continue; // not isosceles
        // check if they are collinear.
        if ( (x2 - x1) * (y3 - y1) == (y2 - y1) * (x3 - x1) ) continue;
 
        // if it passed all the three previous test than it is a valid triangle
        ans++;
    }

    // Note that we are double counting each triangle (ABC and ACB are being
    // counted).
    printf("%d\n", ans / 2);
    return 0;
}
