#include <cstdio>
#include <vector>
using namespace std;

/******************************************************************************
 * NOTE: This comment assumes you've read the explanation and code for medium
 * weird measurements.
 *
 * The solution we had for medium weird measurements was O(N^2), which is too
 * slow for the large problem, where N <= 200000 (we would need about 40 billion
 * basic operations.)
 *
 * The trick for this version of the problem is to realize that all subsequences
 * of a weird sequence are also weird. In other words:
 *
 * If A <= C <= D <= B and [A, B) is weird, then [C, D) is also weird.
 *
 * Therefore we can find the MAXIMAL weird sequences (the weird sequences that
 * adding a single element to them would make them not weird anymore).
 *
 * With that in hand we can simply count the number of subsequences.
 *
 * To avoid double counting we will count the single elements separately.
 *****************************************************************************/

using ll = long long;

ll number_of_subsequences(ll size_of_maximal_sequence) {
    // Don't count subsequences of size 1
    //
    // There are size_of_maximal_sequence elements, and we want to choose 2 of
    // them (for the first and last element of the subsequence, first != last).
    //
    // So there are "size_of_maximal_sequence choose 2" ways.
    return size_of_maximal_sequence * (size_of_maximal_sequence - 1) / 2;
}

int main() {
    // Read the input
    int N;
    scanf("%d", &N);
    vector<int> V(N);
    for (int &x : V) scanf("%d", &x);

    // Compute answer. All single sequences are weird.
    ll ans = N; // Note that now the answer may not fit in an int.

    int start = 0;
    for (int next_element = 1; next_element < N; next_element++) {
        // check if we can add the next element into the current sequence:
        bool can_add = true;
        if (V[next_element] == V[next_element - 1]) can_add = false;
        if (next_element > start + 1) { // for sequences greater than 2 we need weirdness
            if ((V[next_element - 2] < V[next_element-1]) == (V[next_element - 1] < V[next_element]))
                can_add = false;
        }
        
        if (can_add == false) { // we should and the current maximal sequence and start a new one
            ans += number_of_subsequences(next_element - start);
            // maybe the start of the new maximal sequence is at next_element - 1, maybe it's at
            // next_element.
            //
            if (V[next_element] == V[next_element - 1]) start = next_element;
            else start = next_element - 1;
        }
    }
    // make sure to account for the very last maximal weird sequence
    ans += number_of_subsequences(N - start);

    printf("%lld\n", ans);
    return 0;
}
