#include <cstdio>
#include <vector>
using namespace std;

/******************************************************************************
 * NOTE: This comment assumes you've read the explanation and code for small
 * weird measurements.
 *
 * The solution we had for the small weird measurements was O(N^3), which is too
 * slow for the medium problem, where N <= 5000 (we would need about 125 billion
 * basic operations.)
 *
 * Let's try to eliminate one for loop. The trick is the following:
 *
 * Assuming end - start >= 3, the sequence [start, end) correspond to weird
 * measurements if:
 * 1) [start, end - 1) corresponds to weird measurements; and
 * 2) V[end - 2] != V[end - 1]; and
 * 3) (V[end - 3] < V[end - 2]) != (V[end - 2] < V[end - 1])
 *
 * Let's put it to practice.
 *****************************************************************************/

int main() {
    // Read the input
    int N;
    scanf("%d", &N);
    vector<int> V(N);
    for (int &x : V) scanf("%d", &x);

    // Compute answer. All single sequences are weird.
    int ans = N;
    //    My intervals are always "semi-closed". This means that the segment
    //    that corresponds to start, end includes start and doesn't include end
    //    (it's the segment [start, end)).
    //
    //    This is common practice in Computer Science (for instance, an array of
    //    size N has indices from 0 to N-1).
    for (int start = 0; start < N - 1; start++) {
        // first check if the sequence of size 2 is weird. If it isn't we can
        // stop
        if (V[start] == V[start + 1]) continue;
        ans++; // count the sequence of size 2
        for (int end = start + 3; end <= N; end++) {
            // Assumes condition 1 from the comment holds (we will break as soon
            // as it doesn't). So test for conditions 2 and 3.
            
            // condition 2:
            if (V[end - 2] == V[end - 1]) break;
            // condition 3:
            if ((V[end - 3] < V[end - 2]) == (V[end - 2] < V[end - 1])) break;
            ans++;
        }
    }
    printf("%d\n", ans);
    return 0;
}
