#include <cstdio>

/******************************************************************************
 * Let's start remembering how we solved the medium concert throne from warm
 * up 1:
 *
 * Apart from Dudu's seat, there is a seat at (x, y) if and only if:
 *
 * x * y > N                      ; if and only if
 * y > N / x                      ; if and only if
 * y >= floor(N / x) + 1
 *
 * Therefore, for every x there are exactly N - floor(N / x) y's that
 * satisfy the above condition.
 *
 * This solution runs in O(N), which is NOT fast enough for the large throne
 * problem.
 *
 * To have an idea of how to solve the large throne open the attached file
 * "throne.png". This is an example for a hall with 100 seats.
 *
 * The purple points indicate locations where there are no seats. All other
 * seats are color coded, as:
 * red -- dudu seat
 * yellow -- seats with x <= 10
 * green -- seats with y <= 10
 * cyan -- all other seats
 *
 * As we can see, the bulk of the seats are cyan. There are only 10 green rows
 * and 10 yellow columns.
 *
 * It's easy to see that in general there will be only about sqrt(N) green rows
 * and sqrt(N) yellow columns.
 *
 * So the algorithm works by counting each of these different sections
 * separately, for a total time of O(sqrt(N)).
 *
 * There are other algorithms possible, and I would love to hear yours. :)
 */

using ll = long long;

int main() {
    ll N;
    scanf("%lld", &N);
    // find the lower left point of the cyan block
    ll cyan_row, cyan_col;
    for (cyan_row = 1; cyan_row <= N; cyan_row++) {
        cyan_col = N / cyan_row + 1;
        if (cyan_col <= cyan_row) break; // we've reached the point
        // Note that we found the smallest cyan_row such that
        // N / cyan_row + 1 <= cyan_row. 
        //
        // In other words:
        // N <= cyan_row * (cyan_row - 1)
        //
        // So it is clear that cyan_row will be close to sqrt(N), and therefore
        // cyan_col will also be around that number.
        //
        // This makes sure that this loop doesn't run for too long.
    }

    ll ans = 0;
    ans++; // Dudu
    // do cyan -- note that it is a rectangle (if N is a perfect square it will
    // be a square)
    ans += (N - cyan_row + 1) * (N - cyan_col + 1);
    // do green -- solve green just like we did for medium concert throne
    for (int row = 1; row < cyan_row; row++)
        ans += N - N / row;
    // do yellow -- solve yellow just like we did for medium concert throne
    for (int col = 1; col < cyan_col; col++)
        ans += N - N / col;
    printf("%lld\n", ans);
    return 0;
}
