#include <cstdio>

/******************************************************************************
 * The naive way to implement this solution (by simply following the definition
 * of the function) would lead to a solution that is O(B).
 *
 * Since there are up to 1000 test cases we would have up to one trillion (T*B)
 * basic operations. This would take tens of minutes in a modern computer.
 *
 * Let's try to understand how we can solve this faster. :)
 *
 * Take for example the input A = 3, B = 13. The value of the sum is:
 *
 * (1 % 3) + (2 % 3) + (3 % 3) + ... + (13 % 3)
 * ==
 * 0 + 1 + 2 + 0 + 1 + 2 + ... + 1
 *
 * We can group these terms in the following way:
 *
 * 1 + 2 + 0 + -- for i = 1 to 3
 * 1 + 2 + 0 + -- for i = 4 to 6
 * 1 + 2 + 0 + -- for i = 7 to 9
 * 1 + 2 + 0 + -- for i = 10 to 12
 * 1           -- for i = 13 to 13
 *
 * I hope it becomes clear that the sum 1 + 2 + 3 + ... + (A - 1) + 0 appears B/A
 * times (rounding down).
 *
 * Then there is an extra sum of 1 + 2 + ... + (B % A).
 *
 * Let's go to the solution. The solution ends up being a simple formula for
 * each input, so really fast.
 *****************************************************************************/

using ll = long long; // this just declares a shortcut so that I can type ll instead of "long long"

// computes 1 + 2 + ... + K
ll sum_up_to_k(ll k) {
    return k * (k + 1) / 2;
}

int main() {
    int T;
    scanf("%d", &T);
    while (T--) {
        ll A, B;
        scanf("%lld %lld", &A, &B);
        printf("%lld\n", (B / A) * sum_up_to_k(A - 1) + sum_up_to_k(B % A));
    }
    return 0;
}
