#include <cstdio>

/******************************************************************************
 * This problem was intended to be simple by its creator.
 *
 * It is still simple, but it has an unintended complication: floating point
 * numbers (float, double) are not precise enough. You need to do all
 * computation using integers.
 *
 * Below are two possible solutions. One is a simple formula, while the other
 * uses a loop with 100 iterations.
 *****************************************************************************/

int solution_loop(int score1, int score2, int score3) {
    for (int score4 = 0; score4 <= 100; score4++)
        if (15 * score1 + 20 * score2 + 25 * score3 + 40 * score4 >= 90 * 100)
            return score4;
    return -1; // -1 symbolizes "impossible"
}

int solution_formula(int score1, int score2, int score3) {
    // we want the smallest score s4 such that:
    // 15 * s1 + 20 * s2 + 25 * s3 + 40 * s4 >= 90 * 100
    // s4 >= (90 * 100 - 15 * s1 - 20 * s2 - 25 * s3) / 40
    //
    // Since we want the smallest possible integer that satisfies this
    // inequality, we should round the result of the division up (in math terms:
    // we want to "take the ceiling").
    //
    // This is something useful in programming. If all values are positive then:
    //
    // floor(A / B) == A / B -- programming languages usually round down integer
    // divisions
    //
    // ceil(A / B) == (A + B - 1) / B -- try to prove that this is the case :)
    int need_score = (90 * 100 - 15 * score1 - 20 * score2 - 25 * score3 + 39) / 40;
    if (need_score > 100) return -1;
    return need_score;
}

int main() {
    int t;
    scanf("%d", &t);
    while (t--) {
        int score1, score2, score3;
        scanf("%d %d %d", &score1, &score2, &score3);
        // I will use both solutions, of course this is unecessary
        int sol1 = solution_loop(score1, score2, score3);
        int sol2 = solution_formula(score1, score2, score3);
        if (sol1 != sol2) printf("This should never happen.\n");
        if (sol1 == -1) printf("impossible\n");
        else printf("%d\n", sol1);
    }
    return 0;
}
