#include <cstdio>
#include <vector>
#include <algorithm>
using namespace std;
/******************************************************************************
 * One possible solution is to mimic a selection sort
 * (https://en.wikipedia.org/wiki/Selection_sort)
 *
 * The algorithm becomes:
 * For each i = 0, ..., N - 1
 *   Let j be the index where the largest pancake in [i, N) is (the largest
 *      pancake among those after i). We want to put j at the position i,
 *      without changing positions 0, 1, ..., i - 1
 *   Flip just beneath j -- This will put j at the top of the stack
 *   Flip just beneath i -- This will put j at position i
 *
 *
 * This algorithm runs in O(N^2) (because of the flipping operations), but
 * produces a solution with exactly 2*N flips, therefore, correct.
 *
 *
 * Trivia: Finding the smallest number of pancake flips to sort a vector is
 * known to be a very hard problem. Bill Gates co-authored a paper on this
 * on the early days of Microsoft (1979):
 * https://people.eecs.berkeley.edu/~christos/papers/Bounds%20For%20Sorting%20By%20Prefix%20Reversal.pdf
 *****************************************************************************/

int main() {
    int N;
    scanf("%d", &N);
    printf("%d\n", 2 * N); // we know we will make 2*N flips
    vector<int> pancakes(N);
    for (int &x : pancakes) scanf("%d", &x);

    for (int i = 0; i < N; i++) {
        // find the position of the largest pancake, starting from the i-th position
        //   Note that max_elment is not magical. It is implemented with a
        //   for loop, so that this line actually takes time O(N - i)
        int pos = max_element(pancakes.begin() + i, pancakes.end()) - pancakes.begin();
        printf("%d ", pos);
        // Same thing for "reverse". It is internally implemented using a
        // for loop.
        reverse(pancakes.begin() + pos, pancakes.end());
        // Flip the stack at position i, to put the largest at the bottom of the "current stack"
        printf("%d ", i);
        reverse(pancakes.begin() + i, pancakes.end());
    }
    printf("\n");
	return 0;
}

