#include <cstdio>
#include <vector>
using namespace std;

/******************************************************************************
 * The small version of this problem can be solved by simply following the
 * definition of weird measurements.
 *
 * Basically:
 * for every start point
 *    for every end point
 *        check if the segment from start to end form a weird measurement
 *
 * Note that the checking takes O(end - start) to be completed, since we have to
 * go through the whole segment.
 *
 * This yields a solution that is O(N^3), which for N <= 100 yields only one
 * million basic operations, which is fast enough.
 *****************************************************************************/

int main() {
    // Read the input
    int N;
    scanf("%d", &N);
    vector<int> V(N);
    for (int &x : V) scanf("%d", &x);

    // Compute answer. All single sequences are weird.
    int ans = N;
    //    My intervals are always "semi-closed". This means that the segment
    //    that corresponds to start, end includes start and doesn't include end
    //    (it's the segment [start, end)).
    //
    //    This is common practice in Computer Science (for instance, an array of
    //    size N has indices from 0 to N-1).
    for (int start = 0; start < N; start++) {
        for (int end = start + 2; end <= N; end++) {
            bool is_weird = V[start] != V[start + 1]; // this takes care of the sequences of size 2
            for (int i = start + 1; i < end - 1; i++) {
                bool isinc1 = V[i] > V[i - 1];
                bool isinc2 = V[i + 1] > V[i];
                if (isinc1 == isinc2 || V[i-1] == V[i] || V[i] == V[i+1])
                    is_weird = false;
            }
            if (is_weird) ans++;
        }
    }
    printf("%d\n", ans);
    return 0;
}
