#!/usr/bin/env python
import sys

class instance:
  def __init__(self, l):
    self._N = int(l[-1])
    l.pop()
    self._M = int(l[-1])
    l.pop()
    self._l = [[0]*self._M for i in range(self._N)]
    for i in range(self._N):
      for j in range(self._M):
        self._l[i][j] = l[-1]
        l.pop()
  
  def check(self, sol):
    if len(sol) != 6: return False
    # Check if all numbers are in the right range
    for i in range(3):
      if sol[2*i] < 1 or sol[2*i] > self._N or sol[2*i+1] < 0 or sol[2*i+1] > self._M: return False
    # check if they form a line
    dif1 = (sol[2]-sol[0], sol[3]-sol[1])
    dif2 = (sol[4]-sol[2], sol[5]-sol[3])
    if dif1 != dif2: return False
    if abs(dif1[0]) + abs(dif1[1]) != 1: return False
    if self._l[sol[0]-1][sol[1]-1] != self._l[sol[2]-1][sol[3]-1]: return False
    if self._l[sol[0]-1][sol[1]-1] != self._l[sol[4]-1][sol[5]-1]: return False
    return True

def wrong(fil):
  with open(fil, "w") as f:
    f.write("<?xml version=\"1.0\"?>\n")
    f.write("<result outcome = \"No - Wrong Answer\" security = \"{}\"></result>".format(fil))
  sys.exit(0)

def correct(fil):
  with open(fil, "w") as f:
    f.write("<?xml version=\"1.0\"?>\n")
    f.write("<result outcome = \"Yes\" security = \"{}\"></result>".format(fil))
  sys.exit(0)


def read(fil):
  ans = []
  with open(fil, "r") as f:
    for line in f:
       if line.strip() == "": continue
       if line.strip() == "no set found": 
         ans.append([])
         continue
       try:
         ans.append([int(x) for x in line.strip().split(' ')])
         if len(ans[-1]) != 6: wrong(sys.argv[4])
       except:
        wrong(sys.argv[4])
  return ans

if __name__ == "__main__":
  l = []
  with open(sys.argv[1], "r") as f:
    for line in f:
      if line.strip() == "": continue
      l += line.strip().split(' ')
  l.reverse()
  T = int(l[-1])
  l.pop()
  inp = []
  for i in range(T):
    inp.append(instance(l))
  out = read(sys.argv[2])
  ans = read(sys.argv[3])
  if len(out) != T: wrong(sys.argv[4])
  for i in range(T):
    if len(out[i]) == 0:
      if len(ans[i]) != 0: wrong(sys.argv[4])
    elif not inp[i].check(out[i]): wrong(sys.argv[4])
  correct(sys.argv[4])
