import java.io.*;
import java.util.*;
import java.lang.*;

public class solution {
    static final String[] ofwords = { 
        "to", "into", "onto", "above", "below", "from", "by", "is", "at" };
    static final String vowels = "aeiou";
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        scanner.nextInt();        
        
        int cur = 0;        
        while (scanner.hasNext()) {
            String str = scanner.next().toLowerCase();
            
            for (String of : ofwords) {
                if (str.equals(of)) {
                    str = "of";
                    break;
                }
            }

            String out = removePunc(fixVowels(str));
            if (out.length() > 0) {
                System.out.print(out + " ");
                cur += out.length();

                if (cur > 20) {
                    System.out.println();
                    cur = 0;
                }
            }
        }
                
        System.out.println();
    }

    static String fixVowels(String str) {
        int count = 0;
        for (char c : str.toCharArray()) {
            if (vowels.indexOf(c) != -1) {
                count++;                
            }
        }
        
        int skip = count / 2;
        
        StringBuilder res = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (vowels.indexOf(c) != -1 && skip > 0) {
                skip--;
            } else {
                res.append(c);
            }
        }
        return res.toString();
    }
    
    static String removePunc(String str) {
        StringBuilder res = new StringBuilder();
        for (char c : str.toCharArray()) {
            if ('a' <= c && c <= 'z') {
                res.append(c);
            }
        }
        return res.toString();
    }
}
