#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;
/******************************************************************************
 * Find the largest pancake. If it is at the bottom of the stack, forget about
 *   it, otherwise flip (if needed) right below it so that it is on the top.
 *   Then flip the whole stack to put it in the bottom (its righteous position)
 *
 * After that, repeat considering only the stack "without the largest pancake"
 *****************************************************************************/

int main() {
	int T;
	cin >> T;
	cout << T << endl;
	for (int t = 0; t < T; t++) {
		int N;
		cin >> N;
		vector<int> pancakes(N);
		for (int i = 0; i < N; i++) cin >> pancakes[i];
		for (int i = 0; i < N; i++) {
			// find the position of the largest pancake, starting from the i-th position
			int pos = max_element(pancakes.begin() + i, pancakes.end()) - pancakes.begin();
			// If it is already on the correct place, go to the next size
			if (pos == i) continue;
			// If it is not on the "top", put it there:
			if (pos != N-1) {
				cout << pos << " ";
				reverse(pancakes.begin() + pos, pancakes.end());
			}
			// Flip the stack at position i, to put the largest at the bottom of the "current stack"
			cout << i << " ";
			reverse(pancakes.begin() + i, pancakes.end());
		}
		cout << endl;
	}
	return 0;
}

