#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

/******************************************************************************
 * Suppose we want to swap two adjacent pancakes at positions j and j+1.
 *
 * We can do this by doing the following sequence of flips:
 *     flip top j+2 - put the two we want to flip on top
 *     flip top 2 - swap them
 *     flip top j+2 - put everything back in its place
 *****************************************************************************/

int main() {
	int T;
	cin >> T;
	cout << T << endl;
	for (int t = 0; t < T; t++) {
		int N;
		cin >> N;
		vector<int> pancakes(N);
		for (int i = 0; i < N; i++) cin >> pancakes[i];
		for (int i = 0; i < N; i++) {
			for (int j = 0; j < N - 1; j++) {
				if (pancakes[j] < pancakes[j+1]) { // we need to swap them
					cout << j << " ";
					cout << N - 2 << " ";
					cout << j << " ";
					swap(pancakes[j], pancakes[j+1]);
				}
			}
		}
		cout << endl;
	}
	return 0;
}

