#include <iostream>
using namespace std;

// We will read the radii in order. Let the radii be r1 < r2 < r3 < ... < rN
// The total area of the target is pi * rN * rN.
//
// The probability of getting into the first circle is pi*r1*r1/(pi*rN*rN) = r1*r1/(rN*rN)
// The probability of getting into the second circle is:
//    (pi*r2*r2 - pi*r1*r1)/(pi*rN*rN) = (r2*r2 - r1*r1)/(rN*rN) and so forth.
//
// Note that all the probabilities are divided by rN*rN. So we will compute without dividing
// by it, and only divide at the end.
int main() {
	int N;
	int T;
	cin >> T;
	cout << T << endl;
	while (T--) {
		// ans is the answer "so far"
		double ans = 0.;
		cin >> N;
		// last is the previous radius.
		int last = 0;
		for (int i = 0; i < N; i++) {
			int radius, points;
			cin >> radius >> points;
			// As noted in the comment before the main function, this is the contribution of the current
			//   radius to the expectation, apart from dividing by rN*rN
			ans += (radius*radius - last*last)*points;
			last = radius;
		}
		// Finally divide by rN*rN
		ans /= last*last;
		cout << ans << endl;
	}
	return 0;
}
