#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

/******************************************************************************
 * This problem is tricky, and it deserves a larger explanation. Let's start
 * with an example. Suppose we have the following amounts of M&Ms of different
 * colors: 5, 8, 25, 17.
 *
 * The first 8 M&Ms to be eaten will be from color 3, because (25 - 17 = 8).
 * At this point, the number of M&Ms type 3 becomes the same as color 4, so
 * Little John will start alternating among types 3 and 4, for 18 M&Ms,
 * because (17-8)*2 = 18. Then colors 2, 3, 4 will have the same number of
 * M&Ms and will be consumed in a (2, 3, 4) pattern for 9 M&Ms. Finally, the
 * last 20 M&Ms will be eaten in a (1,2,3,4) pattern.
 *
 * Note that the M&M eating process has 4 "stages" in this case: the first 8
 * M&Ms, then the next 18, the next 9, and finally the next 20. The code below
 * first find in which stage "X" stands in. After that, since we know the
 * pattern, we can do a simple computation to know which of the "active" colors
 * will be eaten.
 *
 * Note that the time for this code does not depend "too hardly" on the value
 * of X, but only on the number of different M&M colors. Technically, this
 * solution is O(nlogn) where n is the number of different colors.
 *****************************************************************************/

int main() {
	int T;
	cin >> T;
	cout << T << endl;
	for (int t = 0; t < T; t++) {
		int N;
		// Read everything
		cin >> N;
		vector<int> colors(N);
		for (int i = 0; i < N; i++) cin >> colors[i];
		// Make a copy of the input, so that we can change it
		vector<int> temp = colors;
		// Note that having a color with 0 M&Ms doesn't change the answer, but
		// makes the code simpler.
		temp.push_back(0);
		// Sort it.
		sort(temp.begin(), temp.end());
		int X;
		cin >> X;
		for (int i = 0; i < N; i++) {
			// qt is the number of M&Ms eaten in the current stage
			int qt = (temp[N-i] - temp[N-i-1])*(i+1);
			// if qt >= X it means that the Xth M&M will be eaten in this stage.
			if (qt >= X) {
				// Check which colors are "active" (being eaten)
				vector<int> being_eaten;
				for (int j = 0; j < N; j++)
					if (colors[j] >= temp[N-i]) being_eaten.push_back(j);
				// This is the simple computation to realize what is the Xth M&M to
				// be eaten. Stay a while to convince yourself.
				cout << 1 + being_eaten[(X-1) % being_eaten.size()] << endl;
				break;
			} else {
				// Otherwise, actually "eat" all the M&Ms on that stage.
				X -= qt;
			}
		}
	}
	return 0;
}

