#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

bool check(vector<int>& V, int M) { // check if modulo M will be unique
	vector<int> temp;
	// build the vector of modulos
	for (int i = 0; i < V.size(); i++) temp.push_back(V[i] % M);
	// If we sort the numbers, any repeated elements will be in consecutive spaces
	sort(temp.begin(), temp.end());
	
	for (int i = 0; i < V.size() - 1; i++)
		if (temp[i] == temp[i+1]) return false;

	// If it passed all the tests before, it is unique
	return true;
}

int main() {
	int T;
	cin >> T;
	cout << T << endl;
	for (int t = 0; t < T; t++) {
		int N;
		// Read the input
		cin >> N;
		vector<int> V(N);
		for (int i = 0; i < N; i++) cin >> V[i];
		// Basically test all the modulos until we find one that creates unique identifiers
		int M = 1;
		while (!check(V, M)) M++;
		cout << M << endl;
	}
	return 0;
}
