#include <vector>
#include <algorithm>
#include <iostream>
using namespace std;

// A list of the fermat primes in the allowed range
const int fermat[] = {3,5,17,257,65537};
int main() {
	int T;
	cin >> T;
	cout << T << endl;
	for (int t = 0; t < T; t++) {
		int N;
		bool constructible = true;
		// factors will store all the factors, for later printing.
		vector<int> factors;
		cin >> N;
		// We only need to check until the square root of N (i.e., if p*p <= N).
		//   This is because if a number N has no factors smaller than its square root
		//   it will be prime.
		//
		//   This makes the computation way faster, but wasn't necessary during the
		//   competition.
		for (int p = 2; p*p <= N; p++) {
			// count counts how many factors "p" the number "N" has.
			int count = 0;
			while (N % p == 0) {
				count++;
				N /= p;
				factors.push_back(p);
			}
			// If count is 0, we can go to the next prime number
			if (count == 0) continue;
			if (p == 2) continue; // if p = 2, I don't care about the count
			if (count > 1) constructible = false; // If p != 2, count has to be 1
			// If count is 1, and p is not 2, p has to be one of the 5 fermat primes.
			//   If it's not, it is not constructible.
			if (find(fermat, fermat+5, p) == fermat + 5) constructible = false;
		}
		// Check if there is something ''left'' at N, if there is, it is a prime.
		if (N != 1) {
			factors.push_back(N);
			if (N != 2 && find(fermat, fermat+5, N) == fermat + 5) constructible = false;
		}
		cout << factors.size() << " ";
		for (int i = 0; i < factors.size(); i++) cout << factors[i] << " ";
		cout << (constructible?"constructible":"non-constructible") << endl;
	}
	return 0;
}
