#include <map>
#include <string>
#include <iostream>
#include <cstdlib>
#include <cctype>
using namespace std;

// This is a function that converts a number in the range 1-3888 to roman.
string toroman(int x) {
	string ans;
	// thousands:
	int T = x / 1000;
	switch (T) {
		case 1: ans = "M"; break;
		case 2: ans = "MM"; break;
		case 3: ans = "MMM"; break;
	}
	// hundreds:
	int H = (x % 1000) / 100;
	switch (H) {
		case 1: ans += "C"; break;
		case 2: ans += "CC"; break;
		case 3: ans += "CCC"; break;
		case 4: ans += "CD"; break;
		case 5: ans += "D"; break;
		case 6: ans += "DC"; break;
		case 7: ans += "DCC"; break;
		case 8: ans += "DCCC"; break;
		case 9: ans += "CM"; break;
	}
	// tens:
	T = (x % 100) / 10;
	switch (T) {
		case 1: ans += "X"; break;
		case 2: ans += "XX"; break;
		case 3: ans += "XXX"; break;
		case 4: ans += "XL"; break;
		case 5: ans += "L"; break;
		case 6: ans += "LX"; break;
		case 7: ans += "LXX"; break;
		case 8: ans += "LXXX"; break;
		case 9: ans += "XC"; break;
	}
	// units:
	int U = x % 10;
	switch (U) {
		case 1: ans += "I"; break;
		case 2: ans += "II"; break;
		case 3: ans += "III"; break;
		case 4: ans += "IV"; break;
		case 5: ans += "V"; break;
		case 6: ans += "VI"; break;
		case 7: ans += "VII"; break;
		case 8: ans += "VIII"; break;
		case 9: ans += "IX"; break;
	}
	return ans;
}

int main() {
	int T;
	cin >> T;
	cout << T << endl;
	// To be able to convert from arabiv to roman I just need to call the "toroman" function.
	//   to convert in the other direction, I store a map with all possibilities.
	//
	// By doing this, I don't need to run through all the possibilities for every number I am
	//   trying to convert, we only do it once, before processing any case.
	map<string, int> M;
	for (int i = 1; i <= 3888; i++) M[toroman(i)] = i;
	for (int t = 0; t < T; t++) {
		string s;
		cin >> s;
		if (isdigit(s[0])) cout << toroman(atoi(s.c_str())) << endl;
		else cout << M[s] << endl;
	}
	return 0;
}

