#include <iostream>
using namespace std;

// Creates a vector with a unit step in each of the possible 8 directions.
//   With this trick we don't need to treat each direction separately.
const int dir[][2] = {{1,0},{1,1},{0,1},{-1,1},{-1,0},{-1,-1},{0,-1},{1,-1}};

char board[110][110];
int main() {
	int T;
	cin >> T;
	cout << T << endl;
	for (int t = 0; t < T; t++) {
		// Do the reading for each test case:
		string looking;
		cin >> looking;
		int N, M;
		cin >> N >> M;
		for (int i = 0; i < N; i++) for (int j = 0; j < M; j++) cin >> board[i][j];

		bool found = false;
		// Try to find in every possible start point/direction. Note that internally I call
		//   my rows from 0 to N-1 and my columns from 0 to M-1
		for (int i = 0; i < N; i++) for (int j = 0; j < M; j++) for (int d = 0; d < 8; d++) {
			if (found) break;
			// first check if we can do this.
			//   If we try looking for the word starting on square (i,j) on direction d,
			//     the square of the last letter of the word will be at (ii, jj)
			int ii = i + (looking.size() - 1) * dir[d][0];
			int jj = j + (looking.size() - 1) * dir[d][1];
			//  if (ii, jj) is out of the board, test the next possibility
			if (ii < 0 || ii >= N || jj < 0 || jj >= M) continue;
			// check if we can actually find the word starting at (i,j) on direction d.
			bool isEqual = true;
			for (int k = 0; k < looking.size(); k++) {
				if (board[i + k*dir[d][0]][j + k*dir[d][1]] != looking[k]) isEqual = false;
			}
			// If we find it, print the solution
			if (isEqual) {
				found = true;
				cout << i + 1 << " " << j+1 << endl;
				cout << ii + 1 << " " << jj+1 << endl;
				break;
			}
		}
		// If we can't find it anywhere, register this fact.
		if (!found) cout << "word not found" << endl;
	}
	return 0;
}

