typedef Eigen::Matrix<real, 6, 1> Gradient;
typedef Eigen::Matrix<real, 6, 6> Hessian;
typedef DScalar2<float, 6, Gradient, Hessian> DScalar;
typedef DScalar::DVector3 DVector3;
typedef DScalar::DVector2 DVector2;
      
DVector3 dvPrevPoint(DScalar(0, prevPoint.x()),
		     DScalar(1, prevPoint.y()),
		     DScalar(2, prevPoint.z()));
      
DVector3 dvNextPoint(DScalar(3, nextPoint.x()),
		     DScalar(4, nextPoint.y()),
		     DScalar(5, nextPoint.z()));
      
DVector3 dvSeg = dvNextPoint - dvPrevPoint;
      
DScalar axialStrain = dvSeg.norm()/restEdgeLength - 1.0;
DScalar energy = 0.5 * stretchCoeff * axialStrain * axialStrain * restEdgeLength;
      
Hessian hess = energy.getHessian();
