/*
 * Decompiled with CFR 0.152.
 */
package gl4java.utils.textures;

import gl4java.GLEnum;
import gl4java.GLFunc;
import gl4java.GLUEnum;
import gl4java.GLUFunc;

public abstract class TextureTool
implements GLEnum,
GLUEnum {
    protected GLFunc gl;
    protected GLUFunc glu;
    protected byte[] pixel;
    protected boolean pixelScaled;
    protected int imageWidth;
    protected int imageHeight;
    protected int textWidth;
    protected int textHeight;
    protected int glFormat;
    protected boolean error;

    public String toString() {
        return "Texture " + this.textWidth + "x" + this.textHeight + "[image " + this.imageWidth + "x" + this.imageHeight + "[bpc " + this.getComponents() + "]" + "]";
    }

    protected TextureTool(GLFunc gLFunc, GLUFunc gLUFunc) {
        this.gl = gLFunc;
        this.glu = gLUFunc;
        this.error = false;
        this.pixelScaled = false;
    }

    public final boolean isOk() {
        return !this.error;
    }

    public final int getGLFormat() {
        return this.glFormat;
    }

    public int getGLBytesPerComponent() {
        return 1;
    }

    public int getGLComponentFormat() {
        return 5121;
    }

    public int getComponents() {
        switch (this.glFormat) {
            case 6408: {
                return 4;
            }
            case 6407: {
                return 3;
            }
            case 6410: {
                return 2;
            }
            case 6400: 
            case 6406: 
            case 6409: {
                return 1;
            }
        }
        return 0;
    }

    public final int getImageWidth() {
        return this.imageWidth;
    }

    public final int getImageHeight() {
        return this.imageHeight;
    }

    public final int getTextureWidth() {
        return this.textWidth;
    }

    public final int getTextureHeight() {
        return this.textHeight;
    }

    public static final int getMaxTextureSize(GLFunc gLFunc) {
        int[] nArray = new int[1];
        gLFunc.glGetIntegerv(3379, nArray);
        return nArray[0];
    }

    public void setTextureSize() {
        int n = 0;
        this.textWidth = 1;
        while (this.textWidth < this.imageWidth) {
            this.textWidth *= 2;
            ++n;
        }
        int n2 = 0;
        this.textHeight = 1;
        while (this.textHeight < this.imageHeight) {
            this.textHeight *= 2;
            ++n2;
        }
        int[] nArray = new int[1];
        do {
            int n3;
            this.gl.glTexImage2D(32868, 0, this.getComponents(), this.textWidth, this.textHeight, 0, this.glFormat, 5121, (byte[])null);
            this.glutReportErrors();
            this.gl.glGetTexLevelParameteriv(32868, 0, 4099, nArray);
            this.glutReportErrors();
            if (nArray[0] != 0) continue;
            System.out.println("text size too big: " + this.toString() + ", " + nArray[0] + "!=" + this.glFormat);
            if (this.textWidth > this.textHeight) {
                this.textWidth = 1;
                n3 = --n;
                while (n3 > 0) {
                    this.textWidth *= 2;
                    --n3;
                }
            } else {
                this.textHeight = 1;
                n3 = --n2;
                while (n3 > 0) {
                    this.textHeight *= 2;
                    --n3;
                }
            }
        } while (nArray[0] == 0 && this.textWidth > 1 && this.textHeight > 1);
        if (nArray[0] == 0) {
            System.out.println("GL-ERROR: text size cannot be negotiated  !\n");
            this.error = true;
        }
    }

    public final byte[] getTexture() {
        return this.pixel;
    }

    public boolean scaleTexture2Pow2() {
        if (this.pixelScaled) {
            return true;
        }
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        int[] nArray8 = new int[]{0};
        int[] nArray9 = new int[]{0};
        int[] nArray10 = new int[]{0};
        int[] nArray11 = new int[]{0};
        int[] nArray12 = new int[]{0};
        this.setTextureSize();
        if (this.textWidth != this.imageWidth || this.textHeight != this.imageHeight) {
            byte[] byArray = new byte[this.textWidth * this.textHeight * this.getComponents()];
            this.gl.glGetIntegerv(3328, nArray);
            this.gl.glGetIntegerv(3329, nArray2);
            this.gl.glGetIntegerv(3330, nArray3);
            this.gl.glGetIntegerv(3331, nArray4);
            this.gl.glGetIntegerv(3332, nArray5);
            this.gl.glGetIntegerv(3333, nArray6);
            this.gl.glGetIntegerv(3312, nArray7);
            this.gl.glGetIntegerv(3313, nArray8);
            this.gl.glGetIntegerv(3314, nArray9);
            this.gl.glGetIntegerv(3315, nArray10);
            this.gl.glGetIntegerv(3316, nArray11);
            this.gl.glGetIntegerv(3317, nArray12);
            this.gl.glPixelStorei(3328, 0);
            this.gl.glPixelStorei(3329, 1);
            this.gl.glPixelStorei(3330, 0);
            this.gl.glPixelStorei(3331, 0);
            this.gl.glPixelStorei(3332, 0);
            this.gl.glPixelStorei(3333, 1);
            this.gl.glPixelStorei(3312, 0);
            this.gl.glPixelStorei(3313, 1);
            this.gl.glPixelStorei(3314, this.imageWidth);
            this.gl.glPixelStorei(3315, 0);
            this.gl.glPixelStorei(3316, 0);
            this.gl.glPixelStorei(3317, 1);
            if (this.glu.gluScaleImage(this.glFormat, this.imageWidth, this.imageHeight, 5121, this.pixel, this.textWidth, this.textHeight, 5121, byArray) != 0) {
                this.error = true;
                System.out.println("GL-ERROR: cannot gluScaleImage !\n");
            } else {
                this.pixel = byArray;
            }
            this.gl.glPixelStorei(3328, nArray[0]);
            this.gl.glPixelStorei(3329, nArray2[0]);
            this.gl.glPixelStorei(3330, nArray3[0]);
            this.gl.glPixelStorei(3331, nArray4[0]);
            this.gl.glPixelStorei(3332, nArray5[0]);
            this.gl.glPixelStorei(3333, nArray6[0]);
            this.gl.glPixelStorei(3312, nArray7[0]);
            this.gl.glPixelStorei(3313, nArray8[0]);
            this.gl.glPixelStorei(3314, nArray9[0]);
            this.gl.glPixelStorei(3315, nArray10[0]);
            this.gl.glPixelStorei(3316, nArray11[0]);
            this.gl.glPixelStorei(3317, nArray12[0]);
        }
        if (!this.error) {
            this.pixelScaled = true;
        }
        return this.pixelScaled;
    }

    public boolean scaleTexture4BestSize() {
        if (this.pixelScaled) {
            return true;
        }
        this.setTextureSize();
        if (this.textWidth != this.imageWidth || this.textHeight != this.imageHeight) {
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            int[] nArray3 = new int[]{0};
            int[] nArray4 = new int[]{0};
            int[] nArray5 = new int[]{0};
            int[] nArray6 = new int[]{0};
            int[] nArray7 = new int[]{0};
            int[] nArray8 = new int[]{0};
            int[] nArray9 = new int[]{0};
            int[] nArray10 = new int[]{0};
            int[] nArray11 = new int[]{0};
            int[] nArray12 = new int[]{0};
            byte[] byArray = new byte[this.textWidth * this.textHeight * this.getComponents()];
            int n = this.textWidth;
            int n2 = this.textHeight;
            double d = (double)this.imageWidth / (double)this.imageHeight;
            if (this.textWidth < this.textHeight) {
                n2 = (int)((double)this.textWidth / d + 0.5);
            } else {
                n = (int)((double)this.textHeight * d + 0.5);
            }
            this.gl.glGetIntegerv(3328, nArray);
            this.gl.glGetIntegerv(3329, nArray2);
            this.gl.glGetIntegerv(3330, nArray3);
            this.gl.glGetIntegerv(3331, nArray4);
            this.gl.glGetIntegerv(3332, nArray5);
            this.gl.glGetIntegerv(3333, nArray6);
            this.gl.glGetIntegerv(3312, nArray7);
            this.gl.glGetIntegerv(3313, nArray8);
            this.gl.glGetIntegerv(3314, nArray9);
            this.gl.glGetIntegerv(3315, nArray10);
            this.gl.glGetIntegerv(3316, nArray11);
            this.gl.glGetIntegerv(3317, nArray12);
            this.gl.glPixelStorei(3328, 0);
            this.gl.glPixelStorei(3329, 1);
            this.gl.glPixelStorei(3330, this.textWidth);
            this.gl.glPixelStorei(3331, 0);
            this.gl.glPixelStorei(3332, 0);
            this.gl.glPixelStorei(3333, 1);
            this.gl.glPixelStorei(3312, 0);
            this.gl.glPixelStorei(3313, 1);
            this.gl.glPixelStorei(3314, this.imageWidth);
            this.gl.glPixelStorei(3315, 0);
            this.gl.glPixelStorei(3316, 0);
            this.gl.glPixelStorei(3317, 1);
            if (this.glu.gluScaleImage(this.glFormat, this.imageWidth, this.imageHeight, 5121, this.pixel, n, n2, 5121, byArray) != 0) {
                this.error = true;
                System.out.println("GL-ERROR: cannot gluScaleImage !\n");
            } else {
                this.pixel = byArray;
                this.imageWidth = n;
                this.imageHeight = n2;
            }
            this.gl.glPixelStorei(3328, nArray[0]);
            this.gl.glPixelStorei(3329, nArray2[0]);
            this.gl.glPixelStorei(3330, nArray3[0]);
            this.gl.glPixelStorei(3331, nArray4[0]);
            this.gl.glPixelStorei(3332, nArray5[0]);
            this.gl.glPixelStorei(3333, nArray6[0]);
            this.gl.glPixelStorei(3312, nArray7[0]);
            this.gl.glPixelStorei(3313, nArray8[0]);
            this.gl.glPixelStorei(3314, nArray9[0]);
            this.gl.glPixelStorei(3315, nArray10[0]);
            this.gl.glPixelStorei(3316, nArray11[0]);
            this.gl.glPixelStorei(3317, nArray12[0]);
        }
        if (!this.error) {
            this.pixelScaled = true;
        }
        return this.pixelScaled;
    }

    public boolean texImage2DScaled2Pow2() {
        if (!this.scaleTexture2Pow2()) {
            return false;
        }
        this.gl.glTexImage2D(3553, 0, this.getComponents(), this.getTextureWidth(), this.getTextureHeight(), 0, this.getGLFormat(), this.getGLComponentFormat(), this.getTexture());
        return this.glutReportErrors();
    }

    public boolean texImage2DScaled4BestSize() {
        if (!this.scaleTexture4BestSize()) {
            return false;
        }
        this.gl.glTexImage2D(3553, 0, this.getComponents(), this.getTextureWidth(), this.getTextureHeight(), 0, this.getGLFormat(), this.getGLComponentFormat(), this.getTexture());
        return this.glutReportErrors();
    }

    public boolean texImage2DNonScaled(boolean bl) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        int[] nArray8 = new int[]{0};
        int[] nArray9 = new int[]{0};
        int[] nArray10 = new int[]{0};
        int[] nArray11 = new int[]{0};
        int[] nArray12 = new int[]{0};
        this.gl.glGetIntegerv(3328, nArray);
        this.gl.glGetIntegerv(3329, nArray2);
        this.gl.glGetIntegerv(3330, nArray3);
        this.gl.glGetIntegerv(3331, nArray4);
        this.gl.glGetIntegerv(3332, nArray5);
        this.gl.glGetIntegerv(3333, nArray6);
        this.gl.glGetIntegerv(3312, nArray7);
        this.gl.glGetIntegerv(3313, nArray8);
        this.gl.glGetIntegerv(3314, nArray9);
        this.gl.glGetIntegerv(3315, nArray10);
        this.gl.glGetIntegerv(3316, nArray11);
        this.gl.glGetIntegerv(3317, nArray12);
        this.gl.glPixelStorei(3328, 0);
        this.gl.glPixelStorei(3329, 1);
        this.gl.glPixelStorei(3330, 0);
        this.gl.glPixelStorei(3331, 0);
        this.gl.glPixelStorei(3332, 0);
        this.gl.glPixelStorei(3333, 1);
        this.gl.glPixelStorei(3312, 0);
        this.gl.glPixelStorei(3313, 1);
        this.gl.glPixelStorei(3314, this.imageWidth);
        this.gl.glPixelStorei(3315, 0);
        this.gl.glPixelStorei(3316, 0);
        this.gl.glPixelStorei(3317, 1);
        byte[] byArray = null;
        if (bl) {
            byArray = new byte[this.textWidth * this.textHeight * this.getComponents()];
        }
        this.gl.glTexImage2D(3553, 0, this.getComponents(), this.getTextureWidth(), this.getTextureHeight(), 0, this.getGLFormat(), this.getGLComponentFormat(), byArray);
        this.gl.glTexSubImage2D(3553, 0, 0, 0, this.getImageWidth(), this.getImageHeight(), this.getGLFormat(), this.getGLComponentFormat(), this.getTexture());
        this.gl.glPixelStorei(3328, nArray[0]);
        this.gl.glPixelStorei(3329, nArray2[0]);
        this.gl.glPixelStorei(3330, nArray3[0]);
        this.gl.glPixelStorei(3331, nArray4[0]);
        this.gl.glPixelStorei(3332, nArray5[0]);
        this.gl.glPixelStorei(3333, nArray6[0]);
        this.gl.glPixelStorei(3312, nArray7[0]);
        this.gl.glPixelStorei(3313, nArray8[0]);
        this.gl.glPixelStorei(3314, nArray9[0]);
        this.gl.glPixelStorei(3315, nArray10[0]);
        this.gl.glPixelStorei(3316, nArray11[0]);
        this.gl.glPixelStorei(3317, nArray12[0]);
        return this.glutReportErrors();
    }

    protected final boolean glutReportErrors() {
        int n;
        while ((n = this.gl.glGetError()) != 0) {
            TextureTool.__glutWarning("GL error: " + this.glu.gluErrorString(n));
        }
        return n == 0;
    }

    protected static final void __glutWarning(String string) {
        System.out.println("GLUT: Warning in (unamed): " + string + "\n");
    }
}

