/*
 * Decompiled with CFR 0.152.
 */
package gl4java.utils.textures;

import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.utils.textures.IOTextureLoader;
import java.io.DataInputStream;
import java.io.InputStream;

public class TGATextureLoader
extends IOTextureLoader {
    public TGATextureLoader(GLFunc gLFunc, GLUFunc gLUFunc) {
        super(gLFunc, gLUFunc);
    }

    protected boolean readTexture(InputStream inputStream) {
        try {
            this.glFormat = 6407;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readByte();
            dataInputStream.readByte();
            byte by = dataInputStream.readByte();
            if (by != 2) {
                dataInputStream.close();
                System.out.println("TGATextureLoader: File is not 24bit RGB Data !");
                this.error = true;
                return false;
            }
            dataInputStream.readShort();
            dataInputStream.readShort();
            dataInputStream.readByte();
            dataInputStream.readShort();
            dataInputStream.readShort();
            by = dataInputStream.readByte();
            short s = (short)((short)by & 0xFF);
            by = dataInputStream.readByte();
            s = (short)((short)(((short)by & 0xFF) << 8) | s);
            this.imageWidth = s;
            by = dataInputStream.readByte();
            s = (short)((short)by & 0xFF);
            by = dataInputStream.readByte();
            s = (short)((short)(((short)by & 0xFF) << 8) | s);
            this.imageHeight = s;
            by = dataInputStream.readByte();
            if (by != 24) {
                dataInputStream.close();
                System.out.println("TGATextureLoader: File is not 24bpp Data !");
                this.error = true;
                return false;
            }
            dataInputStream.readByte();
            if (3 != this.getComponents()) {
                dataInputStream.close();
                System.out.println("TGATextureLoader: Currenly only RGB (24bit) data is supported !");
                this.error = true;
                return false;
            }
            this.pixel = new byte[this.imageWidth * this.imageHeight * 3];
            dataInputStream.read(this.pixel, 0, this.pixel.length);
            int n = 0;
            while (n < this.imageWidth * this.imageHeight * 3) {
                byte by2 = this.pixel[n];
                this.pixel[n] = this.pixel[n + 2];
                this.pixel[n + 2] = by2;
                n += 3;
            }
            dataInputStream.close();
            this.setTextureSize();
            return true;
        }
        catch (Exception exception) {
            System.out.println("An exception occured, while loading a TGATexture");
            System.out.println(exception);
            this.error = true;
            return false;
        }
    }
}

