/*
 * Decompiled with CFR 0.152.
 */
package gl4java.utils;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Map;

public class DirectBufferCleanup {
    private Callback cb;
    private Map refToAddrMap;
    private ReferenceQueue queue;
    private volatile Thread t;
    private volatile boolean done = false;

    public DirectBufferCleanup(Callback callback) {
        this.cb = callback;
        this.refToAddrMap = new HashMap();
        this.queue = new ReferenceQueue();
        this.start();
    }

    public synchronized void start() {
        if (this.t == null) {
            this.t = new Thread(new Runnable(){

                public void run() {
                    while (!DirectBufferCleanup.this.done) {
                        try {
                            Reference reference = DirectBufferCleanup.this.queue.remove();
                            Long l = (Long)DirectBufferCleanup.this.refToAddrMap.remove(reference);
                            DirectBufferCleanup.this.cb.cleanup(l);
                            reference.clear();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    DirectBufferCleanup.this.t = null;
                }
            });
            this.done = false;
            this.t.start();
        }
    }

    public synchronized void stop() {
        this.done = true;
        while (this.t != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void register(Buffer buffer) throws IllegalArgumentException {
        try {
            long l = DirectBufferCleanup.getDirectBufferAddress(buffer);
            if (l == 0L) {
                throw new IllegalArgumentException();
            }
            this.refToAddrMap.put(new PhantomReference<Buffer>(buffer, this.queue), new Long(l));
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException();
        }
    }

    private static native long getDirectBufferAddress(Buffer var0);

    public static interface Callback {
        public void cleanup(long var1);
    }
}

