/*
 * Decompiled with CFR 0.152.
 */
package gl4java.swing;

import gl4java.GLContext;
import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.swing.GLAnimJPanel;
import gl4java.swing.GLJPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JApplet;
import javax.swing.JPanel;

public class SimpleGLJApplet1
extends JApplet
implements MouseListener,
WindowListener,
ActionListener,
ItemListener {
    public GLJPanel canvas = null;
    public Button buttonInfo = null;
    public Button buttonFps = null;
    public TextField textFps = null;
    public Checkbox checkUseRepaint = null;
    public Checkbox checkUseFpsSleep = null;
    public Button buttonReStart = null;
    Frame fInfo = null;

    public void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 3));
        this.buttonInfo = new Button("GL4Java");
        this.buttonInfo.addMouseListener(this);
        jPanel2.add(this.buttonInfo);
        this.checkUseRepaint = new Checkbox("repaint", true);
        this.checkUseRepaint.addItemListener(this);
        jPanel2.add(this.checkUseRepaint);
        this.checkUseFpsSleep = new Checkbox("fps-sleep", true);
        this.checkUseFpsSleep.addItemListener(this);
        jPanel2.add(this.checkUseFpsSleep);
        this.buttonReStart = new Button("start/stop");
        this.buttonReStart.addMouseListener(this);
        jPanel2.add(this.buttonReStart);
        this.buttonFps = new Button("fps: ");
        this.buttonFps.addMouseListener(this);
        jPanel2.add(this.buttonFps);
        this.textFps = new TextField("0000000000");
        this.textFps.addActionListener(this);
        jPanel2.add(this.textFps);
        jPanel.add("South", jPanel2);
    }

    public void start() {
        if (this.canvas instanceof GLAnimJPanel) {
            ((GLAnimJPanel)this.canvas).start();
        }
    }

    public void stop() {
        if (this.canvas instanceof GLAnimJPanel) {
            ((GLAnimJPanel)this.canvas).stop();
        }
    }

    public void destroy() {
        if (this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
        if (this.canvas instanceof GLAnimJPanel) {
            ((GLAnimJPanel)this.canvas).stop();
            ((GLAnimJPanel)this.canvas).cvsDispose();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (!(this.canvas instanceof GLAnimJPanel)) {
            return;
        }
        GLAnimJPanel gLAnimJPanel = (GLAnimJPanel)this.canvas;
        if (gLAnimJPanel != null && component.equals(this.buttonFps)) {
            double d = 0.0;
            gLAnimJPanel.stopFpsCounter();
            d = gLAnimJPanel.getFps();
            int n = (int)(d * 100.0);
            d = (double)n / 100.0;
            this.textFps.setText(String.valueOf(d));
            gLAnimJPanel.resetFpsCounter();
        } else if (component.equals(this.buttonInfo)) {
            if (this.fInfo == null && gLAnimJPanel != null && gLAnimJPanel.getGLContext() != null) {
                this.fInfo = this.showGLInfo();
            }
        } else if (component.equals(this.buttonReStart)) {
            gLAnimJPanel.setSuspended(!gLAnimJPanel.isSuspended(), mouseEvent.getClickCount() > 1);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (!(this.canvas instanceof GLAnimJPanel)) {
            return;
        }
        GLAnimJPanel gLAnimJPanel = (GLAnimJPanel)this.canvas;
        if (itemSelectable.equals(this.checkUseRepaint) && gLAnimJPanel != null) {
            gLAnimJPanel.setUseRepaint(this.checkUseRepaint.getState());
            System.out.println("canvas uses repaint: " + this.checkUseRepaint.getState());
        }
        if (itemSelectable.equals(this.checkUseFpsSleep) && gLAnimJPanel != null) {
            gLAnimJPanel.setUseFpsSleep(this.checkUseFpsSleep.getState());
            System.out.println("canvas uses fps-sleep: " + this.checkUseFpsSleep.getState());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (!(this.canvas instanceof GLAnimJPanel)) {
            return;
        }
        GLAnimJPanel gLAnimJPanel = (GLAnimJPanel)this.canvas;
        if (object == this.textFps) {
            try {
                double d = Double.valueOf(this.textFps.getText());
                if (gLAnimJPanel != null) {
                    gLAnimJPanel.setAnimateFps(d);
                    gLAnimJPanel.setSuspended(false, true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("wrong fps format, use float ..");
            }
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this.fInfo && this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this.fInfo && this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public Frame showGLInfo() {
        if (this.canvas == null) {
            return null;
        }
        GLContext gLContext = this.canvas.getGLContext();
        if (gLContext == null) {
            return null;
        }
        GLFunc gLFunc = gLContext.getGLFunc();
        if (gLFunc == null) {
            return null;
        }
        GLUFunc gLUFunc = gLContext.getGLUFunc();
        if (gLFunc == null) {
            return null;
        }
        if (!(this.canvas instanceof GLAnimJPanel)) {
            ((GLAnimJPanel)this.canvas).setSuspended(true, false);
        }
        Frame frame = new Frame("GL4Java Version");
        TextArea textArea = new TextArea(25, 80);
        textArea.setEditable(false);
        frame.add(textArea);
        ((Component)frame).setSize(600, 400);
        String string = "null string";
        if (!gLContext.gljMakeCurrent()) {
            string = "problem in use() method\n";
        } else {
            string = this.canvas.getGLContext().gljGetVersions();
            if (string == null) {
                string = "could not get versions";
            }
            System.out.println(string);
            gLContext.gljFree();
        }
        textArea.append(string);
        frame.addWindowListener(this);
        if (!(this.canvas instanceof GLAnimJPanel)) {
            ((GLAnimJPanel)this.canvas).setSuspended(false, false);
        }
        frame.pack();
        ((Component)frame).setVisible(true);
        return frame;
    }
}

