/*
 * Decompiled with CFR 0.152.
 */
package gl4java.swing;

import gl4java.GLContext;
import gl4java.swing.GLJPanel;
import java.awt.LayoutManager;

public class GLAnimJPanel
extends GLJPanel
implements Runnable {
    protected double FramesPerSec = 20.0;
    protected long mSecPerFrame = 0L;
    protected long dFpsMilli = 0L;
    protected Thread killme = null;
    protected boolean threadSuspended = false;
    protected boolean useRepaint = true;
    protected boolean useFpsSleep = true;
    protected boolean shallWeRender = true;
    private long _fDelay = 0L;
    private long _fDelay_Frames = 10L;
    private boolean _fDelaySync = true;
    private boolean _fDelayRun = false;
    private double fps = 0.0;
    private long fps_duration = 0L;
    private long fps_start = 0L;
    private long fps_frames = 0L;
    private boolean fps_isCounting = true;
    private boolean verboseFps = true;

    public GLAnimJPanel(String string, String string2, LayoutManager layoutManager, boolean bl) {
        super(string, string2, layoutManager, bl);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimJPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimJPanel(boolean bl) {
        super(bl);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimJPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimJPanel() {
        this.setAnimateFps(this.FramesPerSec);
    }

    public void ReInit() {
    }

    public void setUseRepaint(boolean bl) {
        this.useRepaint = bl;
    }

    public void setUseFpsSleep(boolean bl) {
        this.useFpsSleep = bl;
    }

    public boolean getUseRepaint() {
        return this.useRepaint;
    }

    public boolean getUseFpsSleep() {
        return this.useFpsSleep;
    }

    public void start() {
        if (this.killme == null) {
            this.killme = new Thread(this);
            this.killme.start();
            this.resetFpsCounter();
        }
    }

    public synchronized void stop() {
        this.killme = null;
        this.threadSuspended = false;
        this.notify();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.killme == thread) {
            GLAnimJPanel gLAnimJPanel;
            if (this.cvsIsInit()) {
                if (this.shallWeRender) {
                    if (this.useRepaint) {
                        this.repaint();
                    } else {
                        this.sDisplay();
                    }
                } else {
                    gLAnimJPanel = this;
                    synchronized (gLAnimJPanel) {
                        this.threadSuspended = true;
                    }
                }
                if (this.fps_isCounting) {
                    ++this.fps_frames;
                }
            }
            try {
                if (this.useFpsSleep) {
                    if (this.useRepaint) {
                        this.dFpsMilli = this.mSecPerFrame < this._f_dur_total ? this._f_dur_total : this.mSecPerFrame;
                    } else {
                        this.dFpsMilli = this.mSecPerFrame - this._f_dur_total;
                        if (this.dFpsMilli <= 0L) {
                            this.dFpsMilli = 1L;
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(this.dFpsMilli, 0);
                }
                if (!this.threadSuspended) continue;
                this.stopFpsCounter();
                gLAnimJPanel = this;
                synchronized (gLAnimJPanel) {
                    while (this.threadSuspended) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setSuspended(boolean bl) {
        this.setSuspended(bl, false);
    }

    public synchronized void setSuspended(boolean bl, boolean bl2) {
        if (bl) {
            this.shallWeRender = false;
        } else if (!this.isAlive()) {
            this.start();
        } else {
            this.shallWeRender = true;
            this.resetFpsCounter();
            if (bl2) {
                this.ReInit();
            }
            this.threadSuspended = false;
            this.notify();
        }
    }

    public boolean isAlive() {
        if (this.killme == null) {
            return false;
        }
        return this.killme.isAlive();
    }

    public boolean isSuspended() {
        if (this.killme == null) {
            return true;
        }
        return this.threadSuspended;
    }

    public void resetFpsCounter() {
        this.fps = 0.0;
        this.fps_duration = 0L;
        this.fps_frames = 0L;
        this.fps_isCounting = true;
        this.fps_start = System.currentTimeMillis();
    }

    public void stopFpsCounter() {
        if (this.fps_isCounting) {
            long l = System.currentTimeMillis();
            this.fps_duration = l - this.fps_start;
            double d = (double)this.fps_duration / 1000.0;
            if (d == 0.0) {
                d = 1.0;
            }
            this.fps = (double)this.fps_frames / d;
            this.fps_isCounting = false;
        }
        if (this.verboseFps) {
            System.out.println("\nfps    = " + String.valueOf(this.fps));
            System.out.println("time   = " + String.valueOf(this.fps_duration) + " ms");
            System.out.println("frames = " + String.valueOf(this.fps_frames));
            if (this.fps_frames == 0L) {
                this.fps_frames = 1L;
            }
            System.out.println("time/f = " + String.valueOf(this.fps_duration / this.fps_frames) + " ms");
        }
    }

    public void setVerboseFps(boolean bl) {
        this.verboseFps = bl;
    }

    public double getFps() {
        return this.fps;
    }

    public long getFpsDuration() {
        return this.fps_duration;
    }

    public long getFpsFrames() {
        return this.fps_frames;
    }

    public void setAnimateFps(double d, int n) {
        this.setAnimateFps(d);
    }

    public void setAnimateFps(double d) {
        this.FramesPerSec = d;
        this.mSecPerFrame = (long)(1.0 / this.FramesPerSec * 1000.0);
        if (this.verboseFps) {
            System.out.println("\nset fps    := " + String.valueOf(d) + " -> " + String.valueOf(this.mSecPerFrame) + " [ms/frame]");
        }
        this.resetFpsCounter();
    }

    public double getMaxFps() {
        return 1.0 / (double)this._f_dur_total * 1000.0;
    }

    static {
        if (!GLContext.doLoadNativeLibraries(null, null, null)) {
            System.out.println("GLAnimJPanel could not load def. native libs.");
        }
    }
}

