/*
 * Decompiled with CFR 0.152.
 */
package gl4java.drawable;

import gl4java.GLCapabilities;
import gl4java.GLContext;
import gl4java.drawable.SunJDK13GLDrawableFactory;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;

public class Win32SunJDK13GLDrawableFactory
extends SunJDK13GLDrawableFactory {
    private static Method getMaxConfigsMethod;
    private static Method getDefaultPixIDMethod;

    public GraphicsConfiguration getGraphicsConfiguration(GLCapabilities gLCapabilities, GraphicsDevice graphicsDevice) {
        Win32GraphicsConfig win32GraphicsConfig;
        Win32GraphicsConfig[] win32GraphicsConfigArray = this.getAllGraphicsConfigurations((Win32GraphicsDevice)graphicsDevice);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < win32GraphicsConfigArray.length) {
            win32GraphicsConfig = win32GraphicsConfigArray[n5];
            if (Win32SunJDK13GLDrawableFactory.getConfigSupportsOpenGL(win32GraphicsConfig)) {
                if (Win32SunJDK13GLDrawableFactory.getConfigDepthBits(win32GraphicsConfig) > n) {
                    n = Win32SunJDK13GLDrawableFactory.getConfigDepthBits(win32GraphicsConfig);
                }
                if (Win32SunJDK13GLDrawableFactory.getConfigColorBits(win32GraphicsConfig) > n2) {
                    n2 = Win32SunJDK13GLDrawableFactory.getConfigColorBits(win32GraphicsConfig);
                }
                if (Win32SunJDK13GLDrawableFactory.getConfigStencilBits(win32GraphicsConfig) > n3) {
                    n3 = Win32SunJDK13GLDrawableFactory.getConfigStencilBits(win32GraphicsConfig);
                }
                if (Win32SunJDK13GLDrawableFactory.getConfigAccumBits(win32GraphicsConfig) > n4) {
                    n4 = Win32SunJDK13GLDrawableFactory.getConfigAccumBits(win32GraphicsConfig);
                }
            }
            ++n5;
        }
        if (n > 24) {
            n = 24;
        }
        if (gLCapabilities.getDepthBits() > n) {
            gLCapabilities.setDepthBits(n);
        }
        if (gLCapabilities.getStencilBits() > n3) {
            gLCapabilities.setStencilBits(n3);
        }
        if (Win32SunJDK13GLDrawableFactory.getCapsColorBits(gLCapabilities) > n2) {
            gLCapabilities.setRedBits(n2 / 3);
            gLCapabilities.setGreenBits(n2 / 3 + n2 % 3);
            gLCapabilities.setBlueBits(n2 / 3);
        }
        if (Win32SunJDK13GLDrawableFactory.getCapsAccumBits(gLCapabilities) > n4) {
            gLCapabilities.setAccumRedBits(n4 / 3);
            gLCapabilities.setAccumGreenBits(n4 / 3 + n4 % 3);
            gLCapabilities.setAccumBlueBits(n4 / 3);
        }
        if ((win32GraphicsConfig = this.configsSupportsCapabilities(win32GraphicsConfigArray, gLCapabilities, n)) != null) {
            return win32GraphicsConfig;
        }
        boolean bl = false;
        if (gLCapabilities.getDepthBits() > 24) {
            gLCapabilities.setDepthBits(24);
            bl = true;
        } else if (gLCapabilities.getDepthBits() > 16) {
            gLCapabilities.setDepthBits(16);
            bl = true;
        }
        if (Win32SunJDK13GLDrawableFactory.getCapsColorBits(gLCapabilities) > 24) {
            gLCapabilities.setRedBits(8);
            gLCapabilities.setGreenBits(8);
            gLCapabilities.setBlueBits(8);
            bl = true;
        }
        if (gLCapabilities.getAlphaBits() > 8) {
            gLCapabilities.setAlphaBits(8);
            bl = true;
        }
        if (bl) {
            win32GraphicsConfig = this.configsSupportsCapabilities(win32GraphicsConfigArray, gLCapabilities, n);
        }
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig;
        }
        bl = false;
        if (gLCapabilities.getStereo()) {
            gLCapabilities.setStereo(false);
            bl = true;
        }
        if (bl) {
            win32GraphicsConfig = this.configsSupportsCapabilities(win32GraphicsConfigArray, gLCapabilities, n);
        }
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig;
        }
        bl = false;
        if (gLCapabilities.getStencilBits() > 16) {
            gLCapabilities.setStencilBits(16);
            bl = true;
        }
        if (bl) {
            win32GraphicsConfig = this.configsSupportsCapabilities(win32GraphicsConfigArray, gLCapabilities, n);
        }
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig;
        }
        bl = false;
        if (Win32SunJDK13GLDrawableFactory.getCapsAccumBits(gLCapabilities) > 48) {
            gLCapabilities.setAccumRedBits(16);
            gLCapabilities.setAccumGreenBits(16);
            gLCapabilities.setAccumBlueBits(16);
            bl = true;
        }
        if (bl) {
            win32GraphicsConfig = this.configsSupportsCapabilities(win32GraphicsConfigArray, gLCapabilities, n);
        }
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig;
        }
        bl = false;
        if (gLCapabilities.getStencilBits() > 8) {
            gLCapabilities.setStencilBits(8);
            bl = true;
        }
        if (bl) {
            win32GraphicsConfig = this.configsSupportsCapabilities(win32GraphicsConfigArray, gLCapabilities, n);
        }
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig;
        }
        bl = false;
        if (Win32SunJDK13GLDrawableFactory.getCapsAccumBits(gLCapabilities) > 24) {
            gLCapabilities.setAccumRedBits(8);
            gLCapabilities.setAccumGreenBits(8);
            gLCapabilities.setAccumBlueBits(8);
            bl = true;
        }
        if (bl) {
            win32GraphicsConfig = this.configsSupportsCapabilities(win32GraphicsConfigArray, gLCapabilities, n);
        }
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig;
        }
        bl = false;
        if (gLCapabilities.getStencilBits() > 0) {
            gLCapabilities.setStencilBits(0);
            bl = true;
        }
        if (bl) {
            win32GraphicsConfig = this.configsSupportsCapabilities(win32GraphicsConfigArray, gLCapabilities, n);
        }
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig;
        }
        bl = false;
        if (gLCapabilities.getAlphaBits() > 0) {
            gLCapabilities.setAlphaBits(0);
            bl = true;
        }
        if (bl) {
            win32GraphicsConfig = this.configsSupportsCapabilities(win32GraphicsConfigArray, gLCapabilities, n);
        }
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig;
        }
        bl = false;
        return null;
    }

    private Win32GraphicsConfig configsSupportsCapabilities(Win32GraphicsConfig[] win32GraphicsConfigArray, GLCapabilities gLCapabilities, int n) {
        if (GLContext.gljNativeDebug) {
            System.out.println("---------------");
            System.out.println("---------------");
            System.out.println("---------------");
            System.out.println("->check caps: " + gLCapabilities);
            System.out.println("---------------");
        }
        int n2 = 0;
        while (n2 < win32GraphicsConfigArray.length) {
            if (this.configSupportsCapabilities(win32GraphicsConfigArray[n2], gLCapabilities, n)) {
                gLCapabilities.setNativeVisualID(win32GraphicsConfigArray[n2].getVisual());
                return win32GraphicsConfigArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private Win32GraphicsConfig[] getAllGraphicsConfigurations(Win32GraphicsDevice win32GraphicsDevice) {
        try {
            int n = (Integer)getMaxConfigsMethod.invoke((Object)win32GraphicsDevice, new Integer(win32GraphicsDevice.getScreen()));
            int n2 = (Integer)getDefaultPixIDMethod.invoke((Object)win32GraphicsDevice, new Integer(win32GraphicsDevice.getScreen()));
            ArrayList<Win32GraphicsConfig> arrayList = new ArrayList<Win32GraphicsConfig>(n);
            if (n2 == 0) {
                arrayList.add(Win32GraphicsConfig.getConfig((Win32GraphicsDevice)win32GraphicsDevice, (int)n2));
            } else {
                int n3 = 1;
                while (n3 <= n) {
                    arrayList.add(Win32GraphicsConfig.getConfig((Win32GraphicsDevice)win32GraphicsDevice, (int)n3));
                    ++n3;
                }
            }
            Win32GraphicsConfig[] win32GraphicsConfigArray = new Win32GraphicsConfig[arrayList.size()];
            arrayList.toArray(win32GraphicsConfigArray);
            return win32GraphicsConfigArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError(exception.toString());
        }
    }

    private boolean configSupportsCapabilities(Win32GraphicsConfig win32GraphicsConfig, GLCapabilities gLCapabilities, int n) {
        boolean bl;
        boolean bl2 = Win32SunJDK13GLDrawableFactory.getConfigSupportsOpenGL(win32GraphicsConfig) && Win32SunJDK13GLDrawableFactory.getConfigDoubleBuffered(win32GraphicsConfig) == gLCapabilities.getDoubleBuffered() && gLCapabilities.getTrueColor() == Win32SunJDK13GLDrawableFactory.getConfigTrueColor(win32GraphicsConfig) && gLCapabilities.getDepthBits() <= Win32SunJDK13GLDrawableFactory.getConfigDepthBits(win32GraphicsConfig) && n >= Win32SunJDK13GLDrawableFactory.getConfigDepthBits(win32GraphicsConfig) && gLCapabilities.getStencilBits() <= Win32SunJDK13GLDrawableFactory.getConfigStencilBits(win32GraphicsConfig) && (gLCapabilities.getStereo() ? Win32SunJDK13GLDrawableFactory.getConfigStereo(win32GraphicsConfig) : true) && Win32SunJDK13GLDrawableFactory.getCapsColorBits(gLCapabilities) <= Win32SunJDK13GLDrawableFactory.getConfigColorBits(win32GraphicsConfig) && Win32SunJDK13GLDrawableFactory.getCapsAccumBits(gLCapabilities) <= Win32SunJDK13GLDrawableFactory.getConfigAccumBits(win32GraphicsConfig) ? true : (bl = false);
        if (GLContext.gljNativeDebug) {
            System.out.println("->against config: ");
            this.describeGraphicsConfiguration(win32GraphicsConfig);
            System.out.println("---------------");
            System.out.println("result: " + bl);
            System.out.println("---------------");
        }
        return bl;
    }

    private static int getCapsColorBits(GLCapabilities gLCapabilities) {
        return gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
    }

    private static int getCapsAccumBits(GLCapabilities gLCapabilities) {
        return gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits();
    }

    private static boolean getConfigSupportsOpenGL(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualSupportsOpenGL(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static boolean getConfigDoubleBuffered(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualDoubleBuffered(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static boolean getConfigTrueColor(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualTrueColor(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static boolean getConfigStereo(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualStereo(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static int getConfigDepthBits(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualDepthBits(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static int getConfigStencilBits(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualStencilBits(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static int getConfigColorShiftBits(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualColorShiftBits(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static int getConfigColorBits(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualColorBits(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static int getConfigAlphaBits(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualAlphaBits(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static int getConfigAccumBits(Win32GraphicsConfig win32GraphicsConfig) {
        return Win32SunJDK13GLDrawableFactory.getVisualAccumBits(Win32SunJDK13GLDrawableFactory.getScreen(win32GraphicsConfig), win32GraphicsConfig.getVisual());
    }

    private static int getScreen(Win32GraphicsConfig win32GraphicsConfig) {
        return ((Win32GraphicsDevice)win32GraphicsConfig.getDevice()).getScreen();
    }

    private static native boolean getVisualSupportsOpenGL(int var0, int var1);

    private static native boolean getVisualDoubleBuffered(int var0, int var1);

    private static native boolean getVisualTrueColor(int var0, int var1);

    private static native boolean getVisualStereo(int var0, int var1);

    private static native int getVisualDepthBits(int var0, int var1);

    private static native int getVisualStencilBits(int var0, int var1);

    private static native int getVisualColorShiftBits(int var0, int var1);

    private static native int getVisualColorBits(int var0, int var1);

    private static native int getVisualAlphaBits(int var0, int var1);

    private static native int getVisualAccumBits(int var0, int var1);

    private void describeAllGraphicsConfigurations() {
        Win32GraphicsConfig[] win32GraphicsConfigArray = this.getAllGraphicsConfigurations((Win32GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
        System.err.println(win32GraphicsConfigArray.length + " graphics configurations found");
        int n = 0;
        while (n < win32GraphicsConfigArray.length) {
            System.err.println(n + ".");
            Win32GraphicsConfig win32GraphicsConfig = win32GraphicsConfigArray[n];
            this.describeGraphicsConfiguration(win32GraphicsConfig);
            System.err.println();
            ++n;
        }
    }

    private void describeGraphicsConfiguration(Win32GraphicsConfig win32GraphicsConfig) {
        boolean bl = Win32SunJDK13GLDrawableFactory.getConfigSupportsOpenGL(win32GraphicsConfig);
        System.err.println(" SupportsOpenGL: " + bl);
        if (bl) {
            System.err.print(" DoubleBuffered: " + Win32SunJDK13GLDrawableFactory.getConfigDoubleBuffered(win32GraphicsConfig));
            System.err.print(" TrueColor: " + Win32SunJDK13GLDrawableFactory.getConfigTrueColor(win32GraphicsConfig));
            System.err.println(" Stereo: " + Win32SunJDK13GLDrawableFactory.getConfigStereo(win32GraphicsConfig));
            System.err.print(" DepthBits: " + Win32SunJDK13GLDrawableFactory.getConfigDepthBits(win32GraphicsConfig));
            System.err.println(" StencilBits: " + Win32SunJDK13GLDrawableFactory.getConfigStencilBits(win32GraphicsConfig));
            System.err.print(" ColorBits: " + Win32SunJDK13GLDrawableFactory.getConfigColorBits(win32GraphicsConfig));
            System.err.print(" AlphaBits: " + Win32SunJDK13GLDrawableFactory.getConfigAlphaBits(win32GraphicsConfig));
            System.err.println(" AccumBits: " + Win32SunJDK13GLDrawableFactory.getConfigAccumBits(win32GraphicsConfig));
        }
    }

    static {
        try {
            getMaxConfigsMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){
                static /* synthetic */ Class class$sun$awt$Win32GraphicsDevice;

                public Object run() {
                    try {
                        return (class$sun$awt$Win32GraphicsDevice == null ? (class$sun$awt$Win32GraphicsDevice = 1.class$("sun.awt.Win32GraphicsDevice")) : class$sun$awt$Win32GraphicsDevice).getDeclaredMethod("getMaxConfigs", Integer.TYPE);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new InternalError(exception.toString());
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
            ((AccessibleObject)getMaxConfigsMethod).setAccessible(true);
            getDefaultPixIDMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){
                static /* synthetic */ Class class$sun$awt$Win32GraphicsDevice;

                public Object run() {
                    try {
                        return (class$sun$awt$Win32GraphicsDevice == null ? (class$sun$awt$Win32GraphicsDevice = 2.class$("sun.awt.Win32GraphicsDevice")) : class$sun$awt$Win32GraphicsDevice).getDeclaredMethod("getDefaultPixID", Integer.TYPE);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new InternalError(exception.toString());
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
            ((AccessibleObject)getDefaultPixIDMethod).setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError(exception.toString());
        }
    }
}

