/*
 * Decompiled with CFR 0.152.
 */
package gl4java.awt;

import gl4java.GLCapabilities;
import gl4java.GLContext;
import gl4java.GLEnum;
import gl4java.GLFunc;
import gl4java.GLUEnum;
import gl4java.GLUFunc;
import gl4java.drawable.GLDrawable;
import gl4java.drawable.GLEventListener;
import gl4java.drawable.utils.GLEventListenerList;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.ImageObserver;

public class GLOffScreenDrawable
implements GLEnum,
GLUEnum,
GLDrawable {
    protected GLContext glj = null;
    public GLFunc gl = null;
    public GLUFunc glu = null;
    protected boolean cvsInitialized = false;
    protected boolean needCvsDispose = false;
    protected int stencilBits = 0;
    protected int accumSize = 0;
    protected boolean stereoView = false;
    protected boolean rgba = true;
    protected GLContext sharedGLContext;
    protected BufferedImage offImage = null;
    protected int glFormat = 0;
    protected int glType = 0;
    protected int glComps = 0;
    protected int awtFormat = 0;
    protected Dimension offScrnSize = null;
    protected boolean offScrnSizeChanged = false;
    private GLEventListenerList listeners = new GLEventListenerList();
    Graphics gr = null;
    DataBufferInt dbInt = null;
    DataBufferUShort dbUShort = null;
    DataBufferByte dbByte = null;
    protected long _f_dur_self = 0L;
    protected long _f_dur_self_sum = 0L;
    protected long _f_dur_tst_sum = 0L;
    protected long _f_dur_total = 0L;
    protected long _f_dur_total_sum = 0L;
    protected int _f_dur_times = 0;

    public GLOffScreenDrawable(String string, String string2, Dimension dimension) {
        this.gl = GLContext.createGLFunc(string);
        if (this.gl == null) {
            System.out.println("GLFunc implementation " + string + " not created");
        }
        if ((this.glu = GLContext.createGLUFunc(string2)) == null) {
            System.out.println("GLUFunc implementation " + string2 + " not created");
        }
        this.offScrnSizeChanged = true;
        this.offScrnSize = dimension;
    }

    public GLOffScreenDrawable(Dimension dimension) {
        this(null, null, dimension);
    }

    public final GLContext getGLContext() {
        return this.glj;
    }

    public Dimension getSize() {
        return this.offScrnSize;
    }

    public void setSize(Dimension dimension) {
        if (dimension != null && !dimension.equals(this.offScrnSize) || dimension != this.offScrnSize) {
            this.offScrnSizeChanged = true;
            this.offScrnSize = dimension;
            this.initDrawable();
        }
    }

    public BufferedImage getImage() {
        return this.offImage;
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        graphics.drawImage(this.offImage, n, n2, n3, n4, imageObserver);
    }

    public int getGLFormat() {
        return this.glFormat;
    }

    public int getGLType() {
        return this.glType;
    }

    public int getGLComponents() {
        return this.glComps;
    }

    public int getAwtFormat() {
        return this.awtFormat;
    }

    public final synchronized void initDrawable() {
        if (this.glj == null || this.offScrnSizeChanged) {
            this.cvsDispose();
            this.preInit();
            this.glj = GLContext.createOffScreenCtx(this.gl, this.glu, this.stereoView, this.rgba, this.stencilBits, this.accumSize, this.sharedGLContext, this.offScrnSize);
            if (this.glj != null) {
                this.stencilBits = this.glj.getStencilBitNumber();
                this.accumSize = this.glj.getAccumSize();
                this.stereoView = this.glj.isStereoView();
                this.rgba = this.glj.isRGBA();
            }
            if (this.offImage != null) {
                this.offImage.flush();
            }
            this.offImage = null;
            this.offScrnSizeChanged = false;
            this.init();
            Dimension dimension = this.getSize();
            this.reshape(dimension.width, dimension.height);
            if (this.glj != null && this.glj.gljIsInit()) {
                this.cvsInitialized = true;
            }
        }
        this.repaint();
    }

    public final synchronized void repaint() {
        boolean bl = true;
        long l = System.currentTimeMillis();
        if (!this.cvsIsInit()) {
            return;
        }
        this.listeners.sendPreDisplayEvent(this);
        if (!this.glj.gljMakeCurrent()) {
            System.out.println("GLOffScreenDrawable: problem in use() method");
            return;
        }
        if (bl) {
            this.display();
            this._f_dur_self = System.currentTimeMillis() - l;
            if (GLContext.gljClassDebug) {
                this._f_dur_self_sum += this._f_dur_self;
                this.glj.gljCheckGL();
            }
            Dimension dimension = this.offScrnSize;
            int n = dimension.width;
            int n2 = dimension.height;
            long l2 = System.currentTimeMillis();
            if (this.offImage == null || this.offImage.getHeight() != n2 || this.offImage.getWidth() != n) {
                GLCapabilities gLCapabilities = this.glj.getGLCapabilities();
                switch (GLContext.getNativeOSType()) {
                    case -1: {
                        if (gLCapabilities.getAlphaBits() > 0) {
                            this.awtFormat = 2;
                            break;
                        }
                        this.awtFormat = 1;
                        break;
                    }
                    default: {
                        this.awtFormat = gLCapabilities.getAlphaBits() > 0 ? 6 : 5;
                    }
                }
                if (this.offImage != null) {
                    this.offImage.flush();
                }
                this.offImage = new BufferedImage(n, n2, this.awtFormat);
                this.dbByte = null;
                this.dbUShort = null;
                this.dbInt = null;
                switch (this.awtFormat) {
                    case 5: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=3BYTE_BGR, gl=BGR,UNSIGNED_BYTE");
                        }
                        this.glFormat = 32992;
                        this.glType = 5121;
                        this.glComps = 3;
                        this.dbByte = (DataBufferByte)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 6: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=4BYTE_ABGR, gl=BGRA,UNSIGNED_INT_8_8_8_8");
                        }
                        this.glFormat = 32993;
                        this.glType = 32821;
                        this.glComps = 4;
                        this.dbByte = (DataBufferByte)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 1: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=INT_RGB, gl=BGRA,UNSIGNED_BYTE");
                        }
                        this.glFormat = 32993;
                        this.glType = 5121;
                        this.glComps = 4;
                        this.dbInt = (DataBufferInt)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 2: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=INT_ARGB, gl=BGRA,UNSIGNED_BYTE");
                        }
                        this.glFormat = 32993;
                        this.glType = 5121;
                        this.glComps = 4;
                        this.dbInt = (DataBufferInt)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 4: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=INT_BGR, gl=BGRA,UNSIGNED_INT_8_8_8_8");
                        }
                        this.glFormat = 32993;
                        this.glType = 32821;
                        this.glComps = 4;
                        this.dbInt = (DataBufferInt)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 9: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=USHORT_555_RGB, gl=RGBA,UNSIGNED_INT_5_5_5_1");
                        }
                        this.glFormat = 6408;
                        this.glType = 32820;
                        this.glComps = 2;
                        this.dbUShort = (DataBufferUShort)this.offImage.getRaster().getDataBuffer();
                        break;
                    }
                    case 8: {
                        if (GLContext.gljClassDebug) {
                            System.out.println("awt=USHORT_565_RGB, gl=RGB,UNSIGNED_INT_5_6_5");
                        }
                        this.glFormat = 6407;
                        this.glType = 33635;
                        this.glComps = 2;
                        this.dbUShort = (DataBufferUShort)this.offImage.getRaster().getDataBuffer();
                    }
                }
            }
            if (this.dbByte != null) {
                GLContext.gljReadPixelGL2AWT(n, 0, 0, 0, 0, n, n2, this.glFormat, this.glType, this.glj.isDoubleBuffer() ? 1029 : 1028, this.dbByte.getData());
            } else if (this.dbUShort != null) {
                GLContext.gljReadPixelGL2AWT(n, 0, 0, 0, 0, n, n2, this.glFormat, this.glType, this.glj.isDoubleBuffer() ? 1029 : 1028, this.dbUShort.getData());
            } else if (this.dbInt != null) {
                GLContext.gljReadPixelGL2AWT(n, 0, 0, 0, 0, n, n2, this.glFormat, this.glType, this.glj.isDoubleBuffer() ? 1029 : 1028, this.dbInt.getData());
            }
            if (GLContext.gljClassDebug) {
                this._f_dur_tst_sum += System.currentTimeMillis() - l2;
            }
            if (GLContext.gljClassDebug) {
                this.glj.gljCheckGL();
            }
            this.glj.gljFree();
            this._f_dur_total = System.currentTimeMillis() - l;
            if (GLContext.gljClassDebug) {
                this._f_dur_total_sum += this._f_dur_total;
                if (++this._f_dur_times == 100) {
                    System.out.println("self p 100: " + (double)(this._f_dur_self_sum / 100L) / 1000.0 + " s");
                    System.out.println("tst p 100: " + (double)(this._f_dur_tst_sum / 100L) / 1000.0 + " s");
                    System.out.println("gl-bitblit p 100: " + (double)((this._f_dur_total_sum - this._f_dur_self_sum) / 100L) / 1000.0 + " s");
                    System.out.println("total p 100: " + (double)(this._f_dur_total_sum / 100L) / 1000.0 + " s");
                    this._f_dur_self_sum = 0L;
                    this._f_dur_tst_sum = 0L;
                    this._f_dur_total_sum = 0L;
                    this._f_dur_times = 0;
                }
            }
        }
        this.listeners.sendPostDisplayEvent(this);
    }

    public void display() {
        this.listeners.sendDisplayEvent(this);
    }

    public void preInit() {
    }

    public void init() {
        this.listeners.sendInitEvent(this);
    }

    public void doCleanup() {
        this.listeners.sendCleanupEvent(this);
    }

    public boolean cvsIsInit() {
        return this.cvsInitialized;
    }

    public void reshape(int n, int n2) {
        if (GLContext.gljClassDebug) {
            System.out.println("GLOffScreenDrawable::reshape size(" + this.getSize() + ")");
        }
        this.gl.glViewport(0, 0, n, n2);
        this.listeners.sendReshapeEvent(this, n, n2);
    }

    public void cvsDispose() {
        this.cvsInitialized = false;
        if (this.glj != null && this.glj.gljIsInit()) {
            try {
                this.glj.gljFree();
                this.doCleanup();
                this.glj.setEnabled(false);
                this.glj.gljDestroy();
                this.needCvsDispose = false;
            }
            catch (Exception exception) {
                this.needCvsDispose = true;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (GLContext.gljClassDebug) {
            System.out.println("GLCanvas finalize ..");
        }
        this.cvsDispose();
        super.finalize();
    }

    public final int cvsGetWidth() {
        return this.getSize().width;
    }

    public final int cvsGetHeight() {
        return this.getSize().height;
    }

    public void addComponentListener(ComponentListener componentListener) {
    }

    public void removeComponentListener(ComponentListener componentListener) {
    }

    public void addFocusListener(FocusListener focusListener) {
    }

    public void addKeyListener(KeyListener keyListener) {
    }

    public void removeFocusListener(FocusListener focusListener) {
    }

    public void addMouseListener(MouseListener mouseListener) {
    }

    public void removeMouseListener(MouseListener mouseListener) {
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.listeners.add(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.listeners.remove(gLEventListener);
    }

    public GLFunc getGL() {
        return this.gl;
    }

    public GLUFunc getGLU() {
        return this.glu;
    }

    static {
        if (!GLContext.doLoadNativeLibraries(null, null, null)) {
            System.out.println("GLOffScreenDrawable could not load def. native libs.");
        }
    }
}

