/*
 * Decompiled with CFR 0.152.
 */
package gl4java.awt;

import gl4java.GLCapabilities;
import gl4java.GLContext;
import gl4java.GLRunnable;
import gl4java.awt.GLCanvas;
import java.awt.GraphicsConfiguration;

public class GLAnimCanvas
extends GLCanvas
implements GLRunnable {
    protected double FramesPerSec = 20.0;
    protected long mSecPerFrame = 0L;
    protected static int globalThreadNumber = 0;
    protected long dFpsMilli = 0L;
    protected Thread killme = null;
    protected boolean threadSuspended = false;
    protected boolean useRepaint = false;
    protected boolean useFpsSleep = true;
    protected boolean useYield = true;
    protected boolean shallWeRender = true;
    protected boolean isRunning = false;
    protected boolean forceGLFree = false;
    private long _fDelay = 0L;
    private long _fDelay_Frames = 10L;
    private boolean _fDelaySync = true;
    private boolean _fDelayRun = false;
    private double fps = 0.0;
    private long fps_duration = 0L;
    private long fps_start = 0L;
    private long fps_frames = 0L;
    private boolean fps_isCounting = true;

    public static int getGlobalThreadNumber() {
        return globalThreadNumber;
    }

    public GLAnimCanvas(int n, int n2, String string, String string2) {
        super(n, n2, string, string2);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimCanvas(int n, int n2) {
        super(n, n2);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimCanvas(GLCapabilities gLCapabilities, int n, int n2, String string, String string2) {
        super(gLCapabilities, n, n2, string, string2);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimCanvas(GLCapabilities gLCapabilities, int n, int n2) {
        super(gLCapabilities, n, n2);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimCanvas(GraphicsConfiguration graphicsConfiguration, GLCapabilities gLCapabilities, int n, int n2, String string, String string2) {
        super(graphicsConfiguration, gLCapabilities, n, n2, string, string2);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimCanvas(GraphicsConfiguration graphicsConfiguration, GLCapabilities gLCapabilities, int n, int n2) {
        super(graphicsConfiguration, gLCapabilities, n, n2);
        this.setAnimateFps(this.FramesPerSec);
    }

    public void ReInit() {
    }

    public synchronized void setUseRepaint(boolean bl) {
        this.useRepaint = bl;
        this.recomputeAWTThreadRendering();
    }

    public synchronized void setUseFpsSleep(boolean bl) {
        this.useFpsSleep = bl;
    }

    public void setUseYield(boolean bl) {
        this.useYield = bl;
    }

    public boolean getUseRepaint() {
        return this.useRepaint;
    }

    public boolean getUseFpsSleep() {
        return this.useFpsSleep;
    }

    public boolean getUseYield() {
        return this.useYield;
    }

    public boolean ownsThread(Thread thread) {
        return this.killme != null && this.killme == thread;
    }

    public void start() {
        if (this.killme == null) {
            this.killme = new Thread(this);
            this.killme.start();
            this.resetFpsCounter();
        }
    }

    public synchronized void stop() {
        this.killme = null;
        this.threadSuspended = false;
        this.notifyAll();
    }

    public void cvsDispose() {
        this.stop();
        super.cvsDispose();
    }

    public void freeGLContext() {
        this.forceGLFree = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        GLAnimCanvas gLAnimCanvas;
        Thread thread = Thread.currentThread();
        this.isRunning = true;
        int n = 1;
        GLAnimCanvas gLAnimCanvas2 = this;
        synchronized (gLAnimCanvas2) {
            ++globalThreadNumber;
        }
        block12: while (this.killme == thread) {
            block33: {
                block31: {
                    block32: {
                        if (!this.cvsIsInit()) break block31;
                        if (!this.forceGLFree) break block32;
                        this.glj.gljFree(true);
                        this.forceGLFree = false;
                        if (GLContext.gljThreadDebug) {
                            System.out.println("GLAnimCanvas: forceGLFree(1) - gljFree");
                        }
                        break block33;
                    }
                    if (this.shallWeRender) {
                        if (this.useRepaint) {
                            this.repaint();
                        } else {
                            this.sDisplay();
                        }
                        if (this.fps_isCounting) {
                            ++this.fps_frames;
                        }
                        break block33;
                    } else {
                        gLAnimCanvas = this;
                        synchronized (gLAnimCanvas) {
                            this.glj.gljFree(true);
                            this.threadSuspended = true;
                        }
                    }
                    break block33;
                }
                if (GLContext.gljThreadDebug) {
                    System.err.println("Waiting for canvas to initialize (" + n + ")...");
                }
                ++n;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.forceGLFree) {
                this.glj.gljFree(true);
                this.forceGLFree = false;
                if (GLContext.gljThreadDebug) {
                    System.out.println("GLAnimCanvas: forceGLFree(2) - gljFree");
                }
            }
            try {
                if (this.useFpsSleep) {
                    if (this.useRepaint) {
                        this.dFpsMilli = this.mSecPerFrame < this._f_dur ? this._f_dur : this.mSecPerFrame;
                    } else {
                        this.dFpsMilli = this.mSecPerFrame - this._f_dur;
                        if (this.dFpsMilli <= 0L) {
                            this.dFpsMilli = 1L;
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(this.dFpsMilli, 0);
                } else if (this.useYield) {
                    Thread.yield();
                }
                if (!this.threadSuspended) continue;
                this.glj.gljFree(true);
                this.stopFpsCounter();
                gLAnimCanvas = this;
                synchronized (gLAnimCanvas) {
                    while (true) {
                        if (!this.threadSuspended) {
                            continue block12;
                        }
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.glj != null) {
            this.glj.gljFree(true);
        }
        gLAnimCanvas = this;
        synchronized (gLAnimCanvas) {
            --globalThreadNumber;
        }
        this.isRunning = false;
    }

    public synchronized void setSuspended(boolean bl) {
        this.setSuspended(bl, false);
    }

    public synchronized void setSuspended(boolean bl, boolean bl2) {
        if (bl) {
            this.shallWeRender = false;
        } else if (!this.isAlive()) {
            this.start();
        } else {
            this.shallWeRender = true;
            this.resetFpsCounter();
            if (bl2) {
                this.ReInit();
            }
            this.threadSuspended = false;
            this.notifyAll();
        }
    }

    public boolean isAlive() {
        if (this.killme == null) {
            return false;
        }
        return this.killme.isAlive();
    }

    public boolean isSuspended() {
        if (this.killme == null) {
            return true;
        }
        return this.threadSuspended;
    }

    public void resetFpsCounter() {
        this.fps = 0.0;
        this.fps_duration = 0L;
        this.fps_frames = 0L;
        this.fps_isCounting = true;
        this.fps_start = System.currentTimeMillis();
    }

    public void stopFpsCounter() {
        if (this.fps_isCounting) {
            long l = System.currentTimeMillis();
            this.fps_duration = l - this.fps_start;
            double d = (double)this.fps_duration / 1000.0;
            if (d == 0.0) {
                d = 1.0;
            }
            this.fps = (double)this.fps_frames / d;
            this.fps_isCounting = false;
        }
        if (GLContext.gljClassDebug) {
            System.out.println("\nfps    = " + String.valueOf(this.fps));
            System.out.println("time   = " + String.valueOf(this.fps_duration) + " ms");
            System.out.println("frames = " + String.valueOf(this.fps_frames));
            if (this.fps_frames == 0L) {
                this.fps_frames = 1L;
            }
            System.out.println("time/f = " + String.valueOf(this.fps_duration / this.fps_frames) + " ms");
        }
    }

    public void setVerboseFps(boolean bl) {
        System.out.println("GLAnimCanvas.setVerboseFps(boolean) is deprecated and without functionality. Please set gl4java.GLContext.gljClassDebug instead for verbose output !");
    }

    public double getFps() {
        return this.fps;
    }

    public long getFpsDuration() {
        return this.fps_duration;
    }

    public long getFpsFrames() {
        return this.fps_frames;
    }

    public void setAnimateFps(double d, int n) {
        this.setAnimateFps(d);
    }

    public void setAnimateFps(double d) {
        this.FramesPerSec = d;
        this.mSecPerFrame = (long)(1.0 / this.FramesPerSec * 1000.0);
        if (GLContext.gljClassDebug) {
            System.out.println("\nset fps    := " + String.valueOf(d) + " -> " + String.valueOf(this.mSecPerFrame) + " [ms/frame]");
        }
        this.resetFpsCounter();
    }

    public double getMaxFps() {
        return 1.0 / (double)this._f_dur * 1000.0;
    }

    static {
        if (!GLContext.doLoadNativeLibraries(null, null, null)) {
            System.out.println("GLAnimCanvas could not load def. native libs.");
        }
    }
}

