/*
 * Decompiled with CFR 0.152.
 */
package gl4java.applet;

import gl4java.GLContext;
import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.awt.GLCanvas;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class SimpleGLApplet1
extends Applet
implements ActionListener,
WindowListener {
    public GLCanvas canvas = null;
    public Button buttonInfo = null;
    Frame fInfo = null;

    public void init() {
        this.setLayout(new BorderLayout());
        this.buttonInfo = new Button("GL4Java");
        this.add("South", this.buttonInfo);
    }

    public void start() {
        if (GLContext.gljClassDebug) {
            System.out.println("SGLApplet start ..");
        }
        this.buttonInfo.addActionListener(this);
        this.canvas.setVisible(true);
        this.canvas.repaint();
    }

    public void stop() {
        if (GLContext.gljClassDebug) {
            System.out.println("SGLApplet stop ..");
        }
        this.buttonInfo.removeActionListener(this);
        this.canvas.cvsDispose();
    }

    public void destroy() {
        if (GLContext.gljClassDebug) {
            System.out.println("SGLApplet destroy ..");
        }
        if (this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
        this.canvas.cvsDispose();
    }

    protected void finalize() throws Throwable {
        if (GLContext.gljClassDebug) {
            System.out.println("SGLApplet finalize ..");
        }
        super.finalize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.buttonInfo) && this.fInfo == null && this.canvas != null && this.canvas.getGLContext() != null) {
            this.fInfo = this.showGLInfo();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this.fInfo && this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this.fInfo && this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public Frame showGLInfo() {
        if (this.canvas == null) {
            return null;
        }
        GLContext gLContext = this.canvas.getGLContext();
        if (gLContext == null) {
            return null;
        }
        GLFunc gLFunc = gLContext.getGLFunc();
        if (gLFunc == null) {
            return null;
        }
        GLUFunc gLUFunc = gLContext.getGLUFunc();
        if (gLFunc == null) {
            return null;
        }
        Frame frame = new Frame("GL4Java Version");
        TextArea textArea = new TextArea(25, 80);
        textArea.setEditable(false);
        frame.add(textArea);
        ((Component)frame).setSize(600, 400);
        String string = "null string";
        if (!gLContext.gljMakeCurrent()) {
            string = "problem in use() method\n";
        } else {
            string = this.canvas.getGLContext().gljGetVersions();
            if (string == null) {
                string = "could not get versions";
            }
            System.out.println(string);
            gLContext.gljFree();
        }
        textArea.append(string);
        frame.addWindowListener(this);
        frame.pack();
        ((Component)frame).setVisible(true);
        return frame;
    }
}

