package cs4621.lecture05;

import java.io.IOException;



import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;

import cs4621.framework.GLFrame;
import cs4621.framework.Texture2D;

public class SimpleTextureApp extends GLFrame {
	private static final long serialVersionUID = 1L;
	private Texture2D texture;
	private float angle;
	
	public SimpleTextureApp() {
		super("This application loads a texture and displays it!", 640, 480, 60);		
	}	

	public static void main(String args[]) {
		new SimpleTextureApp().run();
	}
	
	public void init(GLAutoDrawable drawable) {
		super.init(drawable);
		final GL2 gl = drawable.getGL().getGL2();
		
		// We want to show the back of the plane as well
		gl.glDisable(GL2.GL_CULL_FACE);			
				
		try {
			texture = new Texture2D(gl, "data/textures/sample.jpg");
		}
		catch (IOException e) {
			System.out.print("Cannot load texture: ");
			System.out.println(e.getMessage());
			terminate();
		}
		
		angle = 0.0f;		
	}
	
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		final GLU glu = new GLU();
			
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);
					
		gl.glLoadIdentity();
		glu.gluLookAt(0, 0, 5, 0, 0, 0, 0, 1, 0);
		
		angle += 1.0f;
		gl.glRotated(30, 0, 1, 0);
		gl.glRotated(angle, 1, 0, 0);
		drawTexturedQuad(gl);
	}
		
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		final GL2 gl = drawable.getGL().getGL2();
		final GLU glu = new GLU();

		gl.glViewport(0, 0, width, height);
		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();

		glu.gluPerspective(
				45.0f, 
				(double) width / (double) height, 
				0.1f,
				1000.0f);

		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();
	}
	
	protected void drawTexturedQuad(GL2 gl) {
		texture.use();
		gl.glBegin(GL2.GL_QUADS);
		{			
			gl.glTexCoord2f(1, 1);
			gl.glVertex3f( 1.0f, 1.0f, 0.0f);
			gl.glTexCoord2f(0, 1);
			gl.glVertex3f(-1.0f, 1.0f, 0.0f);
			gl.glTexCoord2f(0, 0);
			gl.glVertex3f(-1.0f,-1.0f, 0.0f);
			gl.glTexCoord2f(1, 0);
			gl.glVertex3f( 1.0f,-1.0f, 0.0f);
		}
		gl.glEnd();
		texture.unuse();
	}
	
	public void dispose(GLAutoDrawable drawable) {
		texture.dispose();
	}
}
