// Quantization lookup table texture
uniform sampler1D qtable;

// Normals are properly interpolated per fragment
varying vec3 normal;

void main() {

	// Interpolated normals should be normalized 
	vec3 n = normalize(normal);
	
	float intensity =
		dot(n, -normalize(gl_LightSource[0].position.xyz));
		
	float scale = 0;
	if (intensity >= 0 ) {
		scale = texture1D(qtable, intensity).r;
	}
					
	// Set the color of the corresponding pixel
	gl_FragColor =  clamp(gl_Color * scale, 0.0, 1.0);   
}