package cs4621.lecture04;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;

import com.jogamp.opengl.util.gl2.GLUT;

import cs4621.framework.GLFrame;
import cs4621.framework.GlslException;
import cs4621.framework.Program;
import cs4621.framework.Shader;
import cs4621.framework.Uniform;

public class Demo19 extends GLFrame {
	private static final long serialVersionUID = 1L;
	
	private Program program = null;
	
	public Demo19() {
		super("Demo 19: Position as Color", 
				512, 512, 60);		
	}	

	public static void main(String args[]) {
		new Demo19().run();
	}
	
	public void init(GLAutoDrawable drawable) {
		super.init(drawable);
		
		final GL2 gl = drawable.getGL().getGL2();
		
		// Check whether GLSL is supported
		if ( !Shader.checkGlslSupport(gl) ) {
			System.exit(1);
		}
		
		try {
			
			// Load, compile and link the shaders
			this.program = new Program(gl, 
					"position_as_color.vert",  
					"position_as_color.frag");
						
		} catch (GlslException e) {
			
			System.err.println(e.getMessage());
			System.exit(1);			
		}		
		
		gl.glEnable(GL2.GL_DEPTH_TEST);
		gl.glDisable(GL2.GL_CULL_FACE);		
	}
	
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		GLU glu = new GLU();
		GLUT glut = new GLUT();
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);

	    gl.glMatrixMode(GL2.GL_PROJECTION);
	    gl.glLoadIdentity();
	    glu.gluPerspective(45, 1, 0.1, 100);
	    
	    gl.glMatrixMode(GL2.GL_MODELVIEW);
	    gl.glLoadIdentity();
	    glu.gluLookAt(0, 0, 5, 0, 0, 0, 0, 1, 0);
	    
	    gl.glRotated(30, 1, 0, 0);
	    gl.glRotated(-30, 0, 1, 0);
	    gl.glRotated(-30, 0, 0, 1);
	    
	    program.use();
	    
	    glut.glutSolidTeapot(1.0);
	    	    			
		program.unuse();
	}
		
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		// NOP
	}
}
