package cs4621.lecture04;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;

import cs4621.framework.GLFrame;
import cs4621.framework.GlslException;
import cs4621.framework.Program;
import cs4621.framework.Shader;
import cs4621.framework.Uniform;

public class Demo18 extends GLFrame {
	private static final long serialVersionUID = 1L;
	
	private Program program = null;
	private Uniform twisting;
	private Uniform color;
	
	public Demo18() {
		super("Demo 18: Twisting", 
				512, 512, 60);		
	}	

	public static void main(String args[]) {
		new Demo18().run();
	}
	
	public void init(GLAutoDrawable drawable) {
		super.init(drawable);
		
		final GL2 gl = drawable.getGL().getGL2();
		
		// Check whether GLSL is supported
		if ( !Shader.checkGlslSupport(gl) ) {
			System.exit(1);
		}
		
		try {
			
			// Load, compile and link the shaders
			this.program = new Program(gl, 
					"twisting.vert",  
					"twisting.frag");
			
		    twisting = program.getUniform("twisting");
		    color = program.getUniform("color");
			
		} catch (GlslException e) {
			
			System.err.println(e.getMessage());
			System.exit(1);
			
		}		
	}
	
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		GLU glu = new GLU();
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);

	    gl.glMatrixMode(GL2.GL_PROJECTION);
	    gl.glLoadIdentity();
	    glu.gluOrtho2D(-1, 1, -1, 1);
	    
	    gl.glMatrixMode(GL2.GL_MODELVIEW);
	    gl.glLoadIdentity();
	    
	    program.use();
	    
	    twisting.set1Float(5.0f);
	    color.set3Float(0.5f, 0.9f, 0.5f);
	    
	    int count = 200;
	    float size = 1.0f / count;
	    
	    gl.glBegin(GL2.GL_QUADS);
	    
	    for(int i=0;i<count;i++)
	    	for(int j=0;j<count;j++)	    
	    	{
	    		float x = -0.5f + i * size;
	    		float y = -0.5f + j * size;

	    		gl.glVertex2f(x,      y);
	    		gl.glVertex2f(x+size, y);
	    		gl.glVertex2f(x+size, y+size);
	    		gl.glVertex2f(x,      y+size);
	    	}
	    
	    gl.glEnd();
	    			
		program.unuse();
	}
		
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		// NOP
	}
}
