/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.common.jvm.JVMUtil;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NativeWindowFactoryImpl;

public abstract class NativeWindowFactory {
    protected static final boolean DEBUG;
    public static final String TYPE_EGL = "EGL";
    public static final String TYPE_WINDOWS = "Windows";
    public static final String TYPE_X11 = "X11";
    public static final String TYPE_MACOSX = "MacOSX";
    public static final String TYPE_AWT = "AWT";
    public static final String TYPE_DEFAULT = "default";
    private static NativeWindowFactory defaultFactory;
    private static Map registeredFactories;
    private static Class nativeWindowClass;
    private static String nativeWindowingTypePure;
    private static String nativeOSNamePure;
    private static String nativeWindowingTypeCustom;
    private static String nativeOSNameCustom;
    private static boolean isAWTAvailable;
    public static final String AWTComponentClassName = "java.awt.Component";
    public static final String JAWTUtilClassName = "jogamp.nativewindow.jawt.JAWTUtil";
    public static final String X11UtilClassName = "jogamp.nativewindow.x11.X11Util";
    public static final String GDIClassName = "jogamp.nativewindow.windows.GDI";
    public static final String X11JAWTToolkitLockClassName = "jogamp.nativewindow.jawt.x11.X11JAWTToolkitLock";
    public static final String X11ToolkitLockClassName = "jogamp.nativewindow.x11.X11ToolkitLock";
    private static Class jawtUtilClass;
    private static Method jawtUtilGetJAWTToolkitMethod;
    private static Method jawtUtilInitMethod;
    private static Class x11JAWTToolkitLockClass;
    private static Constructor x11JAWTToolkitLockConstructor;
    private static Class x11ToolkitLockClass;
    private static Constructor x11ToolkitLockConstructor;
    private static boolean isFirstUIActionOnProcess;
    private static boolean requiresToolkitLock;
    static boolean initialized;

    protected NativeWindowFactory() {
    }

    private static String _getNativeWindowingType(String string) {
        if (string.startsWith("kd")) {
            return TYPE_EGL;
        }
        if (string.startsWith("wind")) {
            return TYPE_WINDOWS;
        }
        if (string.startsWith("mac os x") || string.startsWith("darwin")) {
            return TYPE_MACOSX;
        }
        if (string.equals("awt")) {
            return TYPE_AWT;
        }
        return TYPE_X11;
    }

    private static void initNativeImpl(boolean bl, ClassLoader classLoader) {
        isFirstUIActionOnProcess = bl;
        String string = null;
        if (TYPE_X11.equals(nativeWindowingTypePure)) {
            string = X11UtilClassName;
        } else if (TYPE_WINDOWS.equals(nativeWindowingTypePure)) {
            string = GDIClassName;
        }
        if (null != string) {
            ReflectionUtil.callStaticMethod((String)string, (String)"initSingleton", (Class[])new Class[]{Boolean.TYPE}, (Object[])new Object[]{new Boolean(bl)}, (ClassLoader)classLoader);
            Boolean bl2 = (Boolean)ReflectionUtil.callStaticMethod((String)string, (String)"requiresToolkitLock", null, null, (ClassLoader)classLoader);
            requiresToolkitLock = bl2;
        } else {
            requiresToolkitLock = false;
        }
    }

    public static synchronized void initSingleton(boolean bl) {
        if (!initialized) {
            Object object;
            initialized = true;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.initSingleton(" + bl + ")");
            }
            AccessControlContext accessControlContext = AccessController.getContext();
            nativeOSNamePure = Debug.getProperty("os.name", false, accessControlContext);
            nativeWindowingTypePure = NativeWindowFactory._getNativeWindowingType(nativeOSNamePure.toLowerCase());
            nativeOSNameCustom = Debug.getProperty("nativewindow.ws.name", true, accessControlContext);
            if (null == nativeOSNameCustom || nativeOSNameCustom.length() == 0) {
                nativeOSNameCustom = nativeOSNamePure;
                nativeWindowingTypeCustom = nativeWindowingTypePure;
            } else {
                nativeWindowingTypeCustom = nativeOSNameCustom;
            }
            ClassLoader classLoader = NativeWindowFactory.class.getClassLoader();
            if (bl) {
                NativeWindowFactory.initNativeImpl(true, classLoader);
            }
            isAWTAvailable = false;
            if (!Debug.getBooleanProperty("java.awt.headless", true, accessControlContext) && ReflectionUtil.isClassAvailable((String)AWTComponentClassName, (ClassLoader)classLoader) && ReflectionUtil.isClassAvailable((String)"javax.media.nativewindow.awt.AWTGraphicsDevice", (ClassLoader)classLoader)) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            jawtUtilClass = Class.forName(NativeWindowFactory.JAWTUtilClassName, false, NativeWindowFactory.class.getClassLoader());
                            jawtUtilInitMethod = jawtUtilClass.getDeclaredMethod("initSingleton", null);
                            jawtUtilInitMethod.setAccessible(true);
                            jawtUtilGetJAWTToolkitMethod = jawtUtilClass.getDeclaredMethod("getJAWTToolkitLock", new Class[0]);
                            jawtUtilGetJAWTToolkitMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                if (null != jawtUtilClass && null != jawtUtilGetJAWTToolkitMethod && null != jawtUtilInitMethod) {
                    ReflectionUtil.callMethod(null, (Method)jawtUtilInitMethod, (Object[])new Object[0]);
                    object = ReflectionUtil.callStaticMethod((String)JAWTUtilClassName, (String)"isHeadlessMode", null, null, (ClassLoader)classLoader);
                    if (object instanceof Boolean) {
                        isAWTAvailable = ((Boolean)object).equals(Boolean.FALSE);
                    }
                }
            }
            if (!bl) {
                NativeWindowFactory.initNativeImpl(false, classLoader);
            }
            registeredFactories = Collections.synchronizedMap(new HashMap());
            object = new NativeWindowFactoryImpl();
            nativeWindowClass = NativeWindow.class;
            NativeWindowFactory.registerFactory(nativeWindowClass, (NativeWindowFactory)object);
            defaultFactory = object;
            if (isAWTAvailable) {
                NativeWindowFactory.registerFactory(ReflectionUtil.getClass((String)AWTComponentClassName, (boolean)false, (ClassLoader)classLoader), (NativeWindowFactory)object);
            }
            if (TYPE_X11 == nativeWindowingTypePure) {
                x11ToolkitLockClass = ReflectionUtil.getClass((String)X11ToolkitLockClassName, (boolean)false, (ClassLoader)classLoader);
                x11ToolkitLockConstructor = ReflectionUtil.getConstructor((Class)x11ToolkitLockClass, (Class[])new Class[]{Long.TYPE});
                if (NativeWindowFactory.isAWTAvailable()) {
                    x11JAWTToolkitLockClass = ReflectionUtil.getClass((String)X11JAWTToolkitLockClassName, (boolean)false, (ClassLoader)classLoader);
                    x11JAWTToolkitLockConstructor = ReflectionUtil.getConstructor((Class)x11JAWTToolkitLockClass, (Class[])new Class[]{Long.TYPE});
                }
            }
            if (DEBUG) {
                System.err.println("NativeWindowFactory firstUIActionOnProcess " + bl);
                System.err.println("NativeWindowFactory requiresToolkitLock " + requiresToolkitLock);
                System.err.println("NativeWindowFactory isAWTAvailable " + isAWTAvailable + ", defaultFactory " + object);
            }
        }
    }

    public static boolean isFirstUIActionOnProcess() {
        return isFirstUIActionOnProcess;
    }

    public static boolean requiresToolkitLock() {
        return requiresToolkitLock;
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static String getNativeOSName(boolean bl) {
        return bl ? nativeOSNameCustom : nativeOSNamePure;
    }

    public static String getNativeWindowType(boolean bl) {
        return bl ? nativeWindowingTypeCustom : nativeWindowingTypePure;
    }

    public static void setDefaultFactory(NativeWindowFactory nativeWindowFactory) {
        defaultFactory = nativeWindowFactory;
    }

    public static NativeWindowFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static ToolkitLock getDefaultToolkitLock() {
        return NativeWindowFactory.getDefaultToolkitLock(NativeWindowFactory.getNativeWindowType(false));
    }

    public static ToolkitLock getDefaultToolkitLock(String string) {
        if (NativeWindowFactory.requiresToolkitLock() && (TYPE_X11 == string || TYPE_AWT == string && TYPE_X11 == NativeWindowFactory.getNativeWindowType(false)) && NativeWindowFactory.isAWTAvailable()) {
            return NativeWindowFactory.getAWTToolkitLock();
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    protected static ToolkitLock getAWTToolkitLock() {
        Object object = ReflectionUtil.callMethod(null, (Method)jawtUtilGetJAWTToolkitMethod, (Object[])new Object[0]);
        if (object instanceof ToolkitLock) {
            return (ToolkitLock)object;
        }
        throw new RuntimeException("JAWTUtil.getJAWTToolkitLock() didn't return a ToolkitLock");
    }

    public static ToolkitLock getNullToolkitLock() {
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock createDefaultToolkitLock(String string, long l) {
        if (NativeWindowFactory.requiresToolkitLock() && TYPE_X11 == string) {
            if (0L == l) {
                throw new RuntimeException("JAWTUtil.createDefaultToolkitLock() called with NULL device but on X11");
            }
            if (NativeWindowFactory.isAWTAvailable()) {
                return NativeWindowFactory.createX11AWTToolkitLock(l);
            }
            return NativeWindowFactory.createX11ToolkitLock(l);
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    protected static ToolkitLock createX11AWTToolkitLock(long l) {
        try {
            return (ToolkitLock)x11JAWTToolkitLockConstructor.newInstance(new Long(l));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static ToolkitLock createX11ToolkitLock(long l) {
        try {
            return (ToolkitLock)x11ToolkitLockConstructor.newInstance(new Long(l));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static NativeWindowFactory getFactory(Class clazz) throws IllegalArgumentException {
        if (nativeWindowClass.isAssignableFrom(clazz)) {
            return (NativeWindowFactory)registeredFactories.get(nativeWindowClass);
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            NativeWindowFactory nativeWindowFactory = (NativeWindowFactory)registeredFactories.get(clazz2);
            if (nativeWindowFactory == null) continue;
            return nativeWindowFactory;
        }
        throw new IllegalArgumentException("No registered NativeWindowFactory for class " + clazz.getName());
    }

    protected static void registerFactory(Class clazz, NativeWindowFactory nativeWindowFactory) {
        if (DEBUG) {
            System.err.println("NativeWindowFactory.registerFactory() " + clazz + " -> " + nativeWindowFactory);
        }
        registeredFactories.put(clazz, nativeWindowFactory);
    }

    public static NativeWindow getNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException, NativeWindowException {
        if (object == null) {
            throw new IllegalArgumentException("Null window object");
        }
        return NativeWindowFactory.getFactory(object.getClass()).getNativeWindowImpl(object, abstractGraphicsConfiguration);
    }

    protected abstract NativeWindow getNativeWindowImpl(Object var1, AbstractGraphicsConfiguration var2) throws IllegalArgumentException;

    static {
        JVMUtil.initSingleton();
        DEBUG = Debug.debug("NativeWindow");
        if (DEBUG) {
            Throwable throwable = new Throwable(Thread.currentThread().getName() + " - Info: NativeWindowFactory.<init>");
            throwable.printStackTrace();
        }
        initialized = false;
    }
}

