/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.newt.util.MonitorMode;

public class ScreenMode
implements Cloneable {
    public static final int ROTATE_0 = 0;
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    MonitorMode monitorMode;
    int rotation;

    public static boolean isRotationValid(int n) {
        return n == 0 || n == 90 || n == 180 || n == 270;
    }

    public ScreenMode(MonitorMode monitorMode, int n) {
        if (!ScreenMode.isRotationValid(n)) {
            throw new RuntimeException("invalid rotation: " + n);
        }
        this.monitorMode = monitorMode;
        this.rotation = n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final MonitorMode getMonitorMode() {
        return this.monitorMode;
    }

    public final int getRotation() {
        return this.rotation;
    }

    public final String toString() {
        return "[ " + this.getMonitorMode() + ", " + this.rotation + " degr ]";
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ScreenMode) {
            ScreenMode screenMode = (ScreenMode)object;
            return screenMode.getMonitorMode().equals(this.getMonitorMode()) && screenMode.getRotation() == this.getRotation();
        }
        return false;
    }

    public final int hashCode() {
        int n = 31 + this.getMonitorMode().hashCode();
        n = (n << 5) - n + this.getRotation();
        return n;
    }
}

