/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class IntIntHashMap
implements Cloneable,
Iterable {
    private final float loadFactor;
    private Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;
    private int keyNotFoundValue = -1;
    private static final boolean isPrimitive;
    private static final Constructor entryConstructor;
    private static final Method equalsMethod;

    public IntIntHashMap() {
        this(16, 0.75f);
    }

    public IntIntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntIntHashMap(int n, float f) {
        if (n > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private IntIntHashMap(float f, int n, int n2, int n3, int n4, int n5, int n6) {
        this.loadFactor = f;
        this.table = new Entry[n];
        this.size = n2;
        this.mask = n3;
        this.capacity = n4;
        this.threshold = n5;
        this.keyNotFoundValue = n6;
    }

    public Object clone() {
        IntIntHashMap intIntHashMap = new IntIntHashMap(this.loadFactor, this.table.length, this.size, this.mask, this.capacity, this.threshold, this.keyNotFoundValue);
        for (int i = this.table.length - 1; i >= 0; --i) {
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            Entry entry = this.table[i];
            while (null != entry) {
                arrayList.add(entry);
                entry = entry.next;
            }
            Entry entry2 = null;
            for (int j = arrayList.size() - 1; j >= 0; --j) {
                entry = (Entry)arrayList.get(j);
                if (isPrimitive) {
                    entry2 = new Entry(entry.key, entry.value, entry2);
                    continue;
                }
                Object object = ReflectionUtil.callMethod(entry.value, IntIntHashMap.getCloneMethod(entry.value), new Object[0]);
                entry2 = (Entry)ReflectionUtil.createInstance(entryConstructor, entry.key, object, entry2);
            }
            intIntHashMap.table[i] = entry2;
        }
        return intIntHashMap;
    }

    public boolean containsValue(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                Boolean bl;
                if (isPrimitive ? entry.value == n : (bl = (Boolean)ReflectionUtil.callMethod(n, equalsMethod, entry.value)) != false) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int get(int n) {
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return this.keyNotFoundValue;
    }

    public int put(int n, int n2) {
        Entry[] entryArray = this.table;
        int n3 = n & this.mask;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n) {
                int n4 = entry.value;
                entry.value = n2;
                return n4;
            }
            entry = entry.next;
        }
        entryArray[n3] = new Entry(n, n2, entryArray[n3]);
        if (this.size++ >= this.threshold) {
            int n5 = 2 * this.capacity;
            Entry[] entryArray2 = new Entry[n5];
            int n6 = n5 - 1;
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry2;
                Entry entry3 = entryArray[i];
                if (entry3 == null) continue;
                entryArray[i] = null;
                do {
                    entry2 = entry3.next;
                    n3 = entry3.key & n6;
                    entry3.next = entryArray2[n3];
                    entryArray2[n3] = entry3;
                } while ((entry3 = entry2) != null);
            }
            this.table = entryArray2;
            this.capacity = n5;
            this.threshold = (int)((float)n5 * this.loadFactor);
            this.mask = this.capacity - 1;
        }
        return this.keyNotFoundValue;
    }

    public void putAll(IntIntHashMap intIntHashMap) {
        for (Entry entry : intIntHashMap) {
            this.put(entry.key, entry.value);
        }
    }

    public int remove(int n) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == n) {
                --this.size;
                if (entry == entry2) {
                    entryArray[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return this.keyNotFoundValue;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    public Iterator<Entry> iterator() {
        return new EntryIterator(this.table);
    }

    public int setKeyNotFoundValue(int n) {
        int n2 = this.keyNotFoundValue;
        this.keyNotFoundValue = n;
        return n2;
    }

    public int getKeyNotFoundValue() {
        return this.keyNotFoundValue;
    }

    public String toString() {
        String string = "{";
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        string = string + "}";
        return string;
    }

    private static Method getCloneMethod(Object object) {
        Class<?> clazz = object.getClass();
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JogampRuntimeException("Class " + clazz + " doesn't support clone()", noSuchMethodException);
        }
        return method;
    }

    static {
        Class<Integer> clazz = Integer.TYPE;
        Class<Integer> clazz2 = Integer.TYPE;
        isPrimitive = clazz.isPrimitive();
        Constructor constructor = null;
        Method method = null;
        if (!isPrimitive) {
            constructor = ReflectionUtil.getConstructor(Entry.class, clazz2, clazz, Entry.class);
            try {
                method = clazz.getDeclaredMethod("equals", Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new JogampRuntimeException("Class " + clazz + " doesn't support equals(Object)");
            }
        }
        entryConstructor = constructor;
        equalsMethod = method;
    }

    public static final class Entry {
        public final int key;
        public int value;
        private Entry next;

        Entry(int n, int n2, Entry entry) {
            this.key = n;
            this.value = n2;
            this.next = entry;
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public String toString() {
            return "[" + this.key + ":" + this.value + "]";
        }
    }

    private static final class EntryIterator
    implements Iterator<Entry> {
        private final Entry[] entries;
        private int index;
        private Entry next;

        private EntryIterator(Entry[] entryArray) {
            this.entries = entryArray;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry next() {
            Entry entry = this.next;
            if (entry != null && entry.next != null) {
                this.next = entry.next;
            } else {
                while (this.index < this.entries.length) {
                    Entry entry2;
                    if ((entry2 = this.entries[this.index++]) == null) continue;
                    this.next = entry2;
                    return entry;
                }
                this.next = null;
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

