package cs4621.lecture03;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;

import cs4621.framework.GLFrame;
import cs4621.framework.GlslException;
import cs4621.framework.Program;
import cs4621.framework.Shader;

public class Demo17 extends GLFrame {
	private static final long serialVersionUID = 1L;
	
	private Program greenShaderProgram = null;
	
	public Demo17() {
		super("Demo 17: Green Triangle Shader", 
				512, 512, 60);		
	}	

	public static void main(String args[]) {
		new Demo17().run();
	}
	
	public void init(GLAutoDrawable drawable) {
		super.init(drawable);
		
		final GL2 gl = drawable.getGL().getGL2();
		
		// Check whether GLSL is supported
		if ( !Shader.checkGlslSupport(gl) ) {
			System.exit(1);
		}
		
		try {
			
			// Load, compile and link the shaders
			this.greenShaderProgram = new Program(gl, 
					"src/shaders/green_shader.vert",  
					"src/shaders/green_shader.frag");
			
		} catch (GlslException e) {
			
			System.err.println(e.getMessage());
			System.exit(1);
			
		}		
	}
	
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		GLU glu = new GLU();
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);
					
		gl.glLoadIdentity();
		gl.glTranslatef(0.0f,0.0f,-10.0f);				
		gl.glRotatef(45, 1.0f, 1.0f, 1.0f);
		
		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();
		glu.gluOrtho2D(-1, 1, -1, 1);
		
		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();
		
		greenShaderProgram.use();
		
		gl.glBegin(GL2.GL_TRIANGLES);
		gl.glVertex3f(-0.5f, -0.5f, 0.0f);
		gl.glVertex3f( 0.5f, -0.5f, 0.0f);
		gl.glVertex3f( 0.0f,  0.5f, 0.0f);
		gl.glEnd();			
		
		greenShaderProgram.unuse();
	}
		
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		// NOP
	}
}
