package cs4621.lecture03;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.JFrame;
import com.jogamp.opengl.util.gl2.GLUT;

import cs4621.framework.GLSceneDrawer;
import cs4621.framework.GLViewPanelWithCameraControl;
import cs4621.framework.PerspectiveCamera;
import cs4621.framework.PerspectiveCameraController;

public class Demo16 extends JFrame implements GLSceneDrawer 
{
	private static final long serialVersionUID = 1L;
	
	private GLViewPanelWithCameraControl glViewPanel;
	
	float[] lightAmbient = new float[] { 1.0f, 1.0f, 1.0f, 1.0f };
	float[] lightDiffuse = new float[] { 1.0f, 1.0f, 1.0f, 1.0f };
	float[] lightSpecular = new float[] { 1.0f, 1.0f, 1.0f, 1.0f };
	float[] lightPosition = new float[] { 0, 5, 5, 1.0f};
	
	float[] ambient = new float[] {0.05f, 0.05f, 0.05f, 0.05f};
	float[] diffuse = new float[] {1.0f, 0.0f, 0.0f, 0.0f};
	float[] specular = new float[] {1.0f, 1.0f, 1.0f, 1.0f};
	float   shininess = 50.0f;

	public Demo16()
	{
		super("Demo 16: Lighting and Material");

		PerspectiveCamera camera = new PerspectiveCamera(0.1f, 100, 45);
		PerspectiveCameraController cameraController = 
				new PerspectiveCameraController(camera, this);

		glViewPanel = new GLViewPanelWithCameraControl(60, cameraController);
		getContentPane().add(glViewPanel, BorderLayout.CENTER);
		glViewPanel.setPreferredSize(new Dimension(800, 600));
			
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
	public static void main(String[] args)
	{
		new Demo16().run();
	}
	
	public void run()
	{		
		setLocationRelativeTo(null);
		pack();
		setVisible(true);
	}	
		
	@Override
	public void init(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		
		gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
		
		gl.glDisable(GL2.GL_COLOR_MATERIAL);
		
		// Set depth buffer.
		gl.glClearDepth(1.0f);	
		gl.glDepthFunc(GL2.GL_LESS);
		gl.glEnable(GL2.GL_DEPTH_TEST);			
		
		// Forces OpenGL to normalize transformed normals to be of
		// unit length before using the normals in OpenGL's lighting equations.
		gl.glEnable(GL2.GL_NORMALIZE);
		
		// Disable face culling.
		gl.glDisable(GL2.GL_CULL_FACE);
				
		gl.glHint(GL2.GL_PERSPECTIVE_CORRECTION_HINT, GL2.GL_NICEST);
		
		glViewPanel.startAnimation();		
	}

	@Override
	public void draw(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		GLUT glut = new GLUT();
				
		gl.glEnable(GL2.GL_LIGHTING);
		gl.glEnable(GL2.GL_LIGHT0);
		
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_AMBIENT, lightAmbient, 0 );
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_DIFFUSE, lightDiffuse, 0 );
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_SPECULAR, lightSpecular, 0 );
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_POSITION, lightPosition, 0);				
	
		gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_AMBIENT, ambient, 0);
		gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE, diffuse, 0);
		gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_SPECULAR, specular, 0);
		gl.glMaterialf(GL2.GL_FRONT_AND_BACK, GL2.GL_SHININESS, shininess);		
		
		gl.glPushMatrix();
		gl.glTranslated(1.0, 0.0, 0.0);
		glut.glutSolidTeapot(1.0);
		gl.glPopMatrix();
		
		gl.glPushMatrix();
		gl.glTranslated(-1.5, 0.0, 0.0);
		gl.glScaled(0.5, 0.5, 0.5);
		drawCube(gl);
		gl.glPopMatrix();
	}
	
	protected void drawCube(GL2 gl){		
		gl.glBegin(GL2.GL_QUADS);					
			gl.glNormal3f(0.0f,1.0f,0.0f);
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);		
			
			gl.glNormal3f(0.0f,-1.0f,0.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);
			
			gl.glNormal3f(0.0f,0.0f,1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);
			
			gl.glNormal3f(0.0f,0.0f,-1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);
			
			gl.glNormal3f(-1.0f,0.0f,0.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);
			
			gl.glNormal3f(1.0f,0.0f,0.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
		gl.glEnd();	
	}
}
