package cs4621.lecture03;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.JButton;
import javax.swing.JFrame;

public class Demo15 extends JFrame implements GLEventListener, ActionListener
{		
	private static final long serialVersionUID = 1L;
	
	private GLCanvas canvas;
	private JButton toggleShadeModelButton;
	private boolean useFlatModel;
	
	public Demo15() {		
		super("CS 4621 Demo 15: Flat and Smooth Shading Model.");		
		
		GLProfile profile = GLProfile.getDefault();
		GLCapabilities capabilities = new GLCapabilities(profile);
		canvas = new GLCanvas(capabilities);
		canvas.addGLEventListener(this);
						
		getContentPane().add(canvas, BorderLayout.CENTER);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);		
		
		toggleShadeModelButton = new JButton("Toggle Shade Model: Flat");
		toggleShadeModelButton.addActionListener(this);
		getContentPane().add(toggleShadeModelButton, BorderLayout.SOUTH);
		useFlatModel = true;
	}
	
	public void run()
	{
		setSize(512, 512);
		setLocationRelativeTo(null);		
		setVisible(true);
	}
	
	public static void main(String[] args) {		
		new Demo15().run();		
	}

	@Override
	public void init(GLAutoDrawable drawable) {		
		// NOP
	}	

	@Override
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();

		gl.glEnable(GL2.GL_DEPTH_TEST);
		gl.glClearDepth(1.0);
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);

		gl.glClearColor(0, 0, 0, 0);
		if (useFlatModel)
		{
			gl.glShadeModel(GL2.GL_FLAT);
		}		
		else
		{
			gl.glShadeModel(GL2.GL_SMOOTH);
		}
	
		gl.glColor3d(1.0, 1.0, 1.0);
		gl.glBegin(GL2.GL_POLYGON);
		{
			gl.glColor3f(1, 1, 0);
			gl.glVertex3d(-0.5, -0.5, 0.0);
			gl.glColor3f(0, 1, 1);
			gl.glVertex3d( 0.5, -0.5, 0.0);
			gl.glColor3f(1, 0, 1);
			gl.glVertex3d( 0.5,  0.5, 0.0);
			gl.glColor3f(1, 1, 1);
			gl.glVertex3d(-0.5,  0.5, 0.0);
		}
		gl.glEnd();
	}

	@Override
	public void reshape(GLAutoDrawable drawble, 
			int x, int y, int width, int height) {
		// NOP
	}

	@Override
	public void dispose(GLAutoDrawable drawable) {
		// NOP		
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == toggleShadeModelButton)
		{
			if (useFlatModel)
			{
				toggleShadeModelButton.setText("Toggle Shading Model: Smooth");
				useFlatModel = false;
				canvas.repaint();
			}
			else
			{
				toggleShadeModelButton.setText("Toggle Shading Model: Flat");
				useFlatModel = true;
				canvas.repaint();
			}
		}		
	}	
}
