package cs4621.examples;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Matrix4f;

import cs4621.framework.GLFrame;
import cs4621.framework.GlslException;
import cs4621.framework.Program;
import cs4621.framework.Shader;
import cs4621.framework.Uniform;

public class SimpleGlslRenderingApp extends GLFrame {
	private static final long serialVersionUID = 1L;
	
	// Temporary buffer to retrieve OpenGL matrix data
	private float[] tmpMatrix = new float[16];
	
	// Stores the model-view and projection matrices
	Matrix4f mvMatrix = new Matrix4f();
	Matrix4f pMatrix = new Matrix4f();
	Matrix4f mvpMatrix = new Matrix4f();
	
	public SimpleGlslRenderingApp() {
		super("This application draws an RGB cube using GLSL!", 
				640, 480, 60);		
	}	

	public static void main(String args[]) {
		new SimpleGlslRenderingApp().run();
	}
	
	public void init(GLAutoDrawable drawable) {
		super.init(drawable);
		
		final GL2 gl = drawable.getGL().getGL2();
		
		// Check whether GLSL is supported
		if ( !Shader.checkGlslSupport(gl) ) {
			System.exit(1);
		}
		
		// Load, compile, link and bind shader program
		if ( !loadShaders(gl, "flat_shader.vs", "flat_shader.fs") ) {
			System.exit(1);
		}
		
	}
	
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);
					
		gl.glLoadIdentity();
		gl.glTranslatef(0.0f,0.0f,-10.0f);				
		gl.glRotatef(45, 1.0f, 1.0f, 1.0f);			
		
		// Set the model-view-projection uniform variable (mvpMatrix)
		setMvpUniformVariable(gl);
		
		drawCube(gl);
	}
		
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		final GL2 gl = drawable.getGL().getGL2();
		final GLU glu = new GLU();

		gl.glViewport(0, 0, width, height);
		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();

		glu.gluPerspective(
				45.0f, 
				(double) width / (double) height, 
				0.1f,
				1000.0f);

		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();
		
		// Retrieve the mode-view matrix
		gl.glGetFloatv(GL2.GL_PROJECTION_MATRIX, this.tmpMatrix, 0);
		
		this.pMatrix.set(this.tmpMatrix);
	}
	
	private Program flatShaderProgram = null;
	
	private Boolean loadShaders(GL2 gl, 
			String vertexFileName, String fragmentFileName) {
				
		try {
			
			// Load, compile and link the shaders
			this.flatShaderProgram = new Program(gl, 
					vertexFileName, fragmentFileName);
			
		} catch (GlslException e) {
			
			System.err.println(e.getMessage());
			return false;
			
		}
		
		// Bind the successfully compiled + linked program
		this.flatShaderProgram.use();
		 
		return true;
	}
	
	private void setMvpUniformVariable(GL2 gl) {
		// Retrieve the mode-view matrix
		gl.glGetFloatv(GL2.GL_MODELVIEW_MATRIX, this.tmpMatrix, 0);
		
		this.mvMatrix.set(this.tmpMatrix);
		
		// Create the model-view-projection matrix
		this.mvpMatrix.setIdentity();
		
		// Transpose both matrices, as OpenGL stores them in column major order
		this.mvpMatrix.mulTransposeBoth(this.pMatrix, this.mvMatrix);
						
		// Get the Uniform object, that corresponds to the mvpMatrix uniform
		Uniform mvpMatrixUniform = 
			this.flatShaderProgram.GetUniforms().get("mvpMatrix");
		
		assert(mvpMatrixUniform != null);
		
		// Set the new model-view-projection matrix
		mvpMatrixUniform.setMatrix4(mvpMatrix);		
	}
	
	protected void drawCube(GL2 gl){		
		gl.glBegin(GL2.GL_QUADS);					
			gl.glColor3f(0.0f,1.0f,0.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);		
			
			gl.glColor3f(1.0f,0.5f,0.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);
			
			gl.glColor3f(1.0f,0.0f,0.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);
			
			gl.glColor3f(1.0f,1.0f,0.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);
			
			gl.glColor3f(0.0f,0.0f,1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);
			
			gl.glColor3f(1.0f,0.0f,1.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
		gl.glEnd();	
	}
}
