package cs4621.examples;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;

import cs4621.framework.GLSceneDrawer;
import cs4621.framework.GLFrame;
import cs4621.framework.PerspectiveCameraController;
import cs4621.framework.PerspectiveCamera;
import cs4621.framework.PickingController;
import cs4621.framework.PickingEventListener;

public class PickingApp extends GLFrame implements GLSceneDrawer, PickingEventListener {
	private static final long serialVersionUID = 1L;	
	
	PerspectiveCameraController cameraController;
	PickingController pickingController;

	public PickingApp() {		
		super("Pick object by left clicking on it!", 512, 512, 60);
		PerspectiveCamera camera = new PerspectiveCamera(0.1f, 100, 45); 
		cameraController = new PerspectiveCameraController(camera, this);
		pickingController = new PickingController(cameraController);
		pickingController.addPickingEventListener(this);
		addGLController(pickingController);
	}
	
	public void init(GLAutoDrawable drawable) {
		super.init(drawable);
	}
	
	public void display(GLAutoDrawable drawable) {
		// NOP
	}
	
	public void draw(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		drawCube(gl);
	}
	
	protected void drawCube(GL2 gl){
		gl.glLoadName(1);
		
		gl.glBegin(GL2.GL_QUADS);					
			gl.glColor3f(0.0f,1.0f,0.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);		
			
			gl.glColor3f(1.0f,0.5f,0.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);
			
			gl.glColor3f(1.0f,0.0f,0.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);
			
			gl.glColor3f(1.0f,1.0f,0.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);
			
			gl.glColor3f(0.0f,0.0f,1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);
			
			gl.glColor3f(1.0f,0.0f,1.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
		gl.glEnd();	
	}
	
	public static void main(String[] args) {
		new PickingApp().run();
	}

	@Override
	public void objectPicked(Object source, int objectId, Vector3f pickLocation, Vector2f mousePosition)
	{ 
		System.out.println("object " + Integer.toString(objectId) + " is picked!");
		System.out.println("picked position is (" + 
				Float.toString(pickLocation.x) + "," +
				Float.toString(pickLocation.y) + "," +
				Float.toString(pickLocation.z) + ")");
	}

	@Override
	public void startPickingMode(Object source)
	{
		System.out.println("start picking mode");
	}

	@Override
	public void stopPickingMode(Object source)
	{
		System.out.println("stop picking mode");		
	}
}
