package cs4621.examples;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;

import cs4621.framework.GLSceneDrawer;
import cs4621.framework.GLFrame;
import cs4621.framework.OrthographicCamera;
import cs4621.framework.OrthographicCameraController;

public class OrthographicCameraControlApp extends GLFrame implements GLSceneDrawer {
	private static final long serialVersionUID = 1L;	
		
	OrthographicCameraController cameraController;

	public OrthographicCameraControlApp() {		
		super("Control the camera by dragging the right mouse button and holding ALT, or CTRL!", 512, 512, 60);
		OrthographicCamera camera = new OrthographicCamera(0.1f, 100, 45);
		cameraController = new OrthographicCameraController(camera, this);
		addGLController(cameraController);
	}
	
	public void init(GLAutoDrawable drawable) {
		super.init(drawable);		
	}
	
	public void display(GLAutoDrawable drawable) {
		// NOP
	}
	
	public void draw(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		drawCube(gl);
	}
	
	protected void drawCube(GL2 gl){		
		gl.glBegin(GL2.GL_QUADS);					
			gl.glColor3f(0.0f,1.0f,0.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);		
			
			gl.glColor3f(1.0f,0.5f,0.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);
			
			gl.glColor3f(1.0f,0.0f,0.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);
			
			gl.glColor3f(1.0f,1.0f,0.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);
			
			gl.glColor3f(0.0f,0.0f,1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);
			
			gl.glColor3f(1.0f,0.0f,1.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
		gl.glEnd();	
	}
	
	public static void main(String[] args) {
		new OrthographicCameraControlApp().run();
	}
}
