package cs4621.examples;

import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;

import cs4621.framework.GLFrame;

public class KeyboardInputApp extends GLFrame {
	private static final long serialVersionUID = 1L;
	public static int CORNERS = 256;	
	
	private class Ball {
		public double x, y;
		public double vx, vy;
		public double radius;
		public double r, g, b;
		
		private double random(double lower, double upper)
		{			
			return lower + (upper - lower) * Math.random(); 
		}
		
		public Ball() {
			x = random(-1, 1);
			y = random(-1, 1);
			vx = random(-0.05, 0.05);
			vy = random(-0.05, 0.05);
			radius = random(0.02, 0.1);
			r = random(0.5, 1.0);
			g = random(0.5, 1.0);
			b = random(0.5, 1.0);
		}
		
		public void draw(GL2 gl)
		{
			gl.glColor3d(r, g, b);
			gl.glBegin(GL2.GL_TRIANGLE_FAN);
			{
				gl.glVertex2d(x, y);
				for(int i=0;i<CORNERS;i++)
				{
					double theta = 2*Math.PI*i/CORNERS;
					double xx = x + radius * Math.cos(theta);
					double yy = y + radius * Math.sin(theta);
					gl.glVertex2d(xx,yy);
				}
				gl.glVertex2d(x + radius, y);
			}
			gl.glEnd();
		}
		
		public void update()
		{
			x += vx;
			y += vy;

			if (x + radius > 1)
			{
				x = 1 - radius;
				vx = -Math.abs(vx);
			}
			if (x - radius < -1)
			{
				x = -1 + radius;
				vx = Math.abs(vx);
			}
			if (y + radius > 1)
			{
				y = 1 - radius;
				vy = -Math.abs(vy);
			}
			if (y - radius < -1)
			{
				y = -1 + radius;
				vy = Math.abs(vy);
			}
		}
	}
	
	private ArrayList<Ball> balls;

	public KeyboardInputApp() {		
		super("Press SPACE to create new balls!", 512, 512, 60);
		balls = new ArrayList<Ball>();		
	}
	
	public static void main(String[] args) {
		new KeyboardInputApp().run();
	}
	
	public void reshape(GLAutoDrawable drawable, int x, int y, int w, int h) {
		final GL2 gl = drawable.getGL().getGL2();
		final GLU glu = new GLU();
		
		gl.glViewport(0,0,w,h);

		if (w == 0) w = 1;
		if (h == 0) h = 1;

		double aspect = (double)w / h;

		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();
		if (w > h)
			glu.gluOrtho2D(-aspect, aspect, -1, 1);
		else
			glu.gluOrtho2D(-1, 1, -1/aspect, 1/aspect);		
	}
	
	public void display(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);
					
		for(Ball ball : balls) {
			ball.update();
			ball.draw(gl);
		}		
	}
	
	public void keyPressed(KeyEvent key) {
		if (key.getKeyCode() == KeyEvent.VK_SPACE) {
			balls.add(new Ball());
		}
		else
			super.keyPressed(key);
	}
}
