package cs4621.examples;

import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.JFrame;

import cs4621.framework.GLFourViewPanel;
import cs4621.framework.GLSceneDrawer;
import cs4621.framework.Texture2D;

public class FourViewPanelApp extends JFrame implements GLSceneDrawer {
	private static final long serialVersionUID = 1L;
	
	Texture2D texture = null;
	GLFourViewPanel panel;
	
	public FourViewPanelApp() {
		super("Four Window Example");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		addWindowListener( new WindowAdapter() {
            public void windowClosing( WindowEvent windowevent ) { 
            	terminate();
            }
        });
		
		panel = new GLFourViewPanel(60, this);	
		getContentPane().add(panel, BorderLayout.CENTER);		
	}
	
	public void run()
	{
		setSize(800, 600);
		setLocationRelativeTo(null);
		setVisible(true);		
	}	
		
	public static void main(String[] args)
	{
		new FourViewPanelApp().run();		
	}
	
	public void init(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		
		gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
		
		gl.glEnable(GL2.GL_COLOR_MATERIAL);
		
		// Set depth buffer.
		gl.glClearDepth(1.0f);		
		gl.glDepthFunc(GL2.GL_LESS);
		gl.glEnable(GL2.GL_DEPTH_TEST);
		
		// Set blending mode.
		gl.glBlendFunc(GL2.GL_SRC_ALPHA, GL2.GL_ONE_MINUS_SRC_ALPHA);
		gl.glEnable(GL2.GL_BLEND);
		
		// Forces OpenGL to normalize transformed normals to be of
		// unit length before using the normals in OpenGL's lighting equations.
		gl.glEnable(GL2.GL_NORMALIZE);
		
		// Cull back faces.
		gl.glEnable(GL2.GL_CULL_FACE);
				
		gl.glHint(GL2.GL_PERSPECTIVE_CORRECTION_HINT, GL2.GL_NICEST);
			
		if (texture == null)
		{
			try {
				texture = new Texture2D(gl, "data/textures/sample.jpg");
			}
			catch (IOException e) {
				System.out.print("Cannot load texture: ");
				System.out.println(e.getMessage());
				terminate();
			}
		}
		
		panel.startAnimation();
	}

	public void draw(GLAutoDrawable drawable) {
		final GL2 gl = drawable.getGL().getGL2();
		drawTexturedQuad(gl);
	}
	
	protected void drawTexturedQuad(GL2 gl) {
		texture.use();
		gl.glBegin(GL2.GL_QUADS);
		{			
			gl.glTexCoord2f(1, 1);
			gl.glVertex3f( 1.0f, 1.0f, 0.0f);
			gl.glTexCoord2f(0, 1);
			gl.glVertex3f(-1.0f, 1.0f, 0.0f);
			gl.glTexCoord2f(0, 0);
			gl.glVertex3f(-1.0f,-1.0f, 0.0f);
			gl.glTexCoord2f(1, 0);
			gl.glVertex3f( 1.0f,-1.0f, 0.0f);
		}
		gl.glEnd();
		texture.unuse();
	}
	
	protected void dispose(GLAutoDrawable drawable)
	{
		texture.dispose();
	}
	
	protected void drawCube(GL2 gl){
		gl.glBegin(GL2.GL_QUADS);					
			gl.glColor3f(0.0f,1.0f,0.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);		
			
			gl.glColor3f(1.0f,0.5f,0.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);
			
			gl.glColor3f(1.0f,0.0f,0.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);
			
			gl.glColor3f(1.0f,1.0f,0.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);
			
			gl.glColor3f(0.0f,0.0f,1.0f);			
			gl.glVertex3f(-1.0f, 1.0f, 1.0f);			
			gl.glVertex3f(-1.0f, 1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f,-1.0f);			
			gl.glVertex3f(-1.0f,-1.0f, 1.0f);
			
			gl.glColor3f(1.0f,0.0f,1.0f);			
			gl.glVertex3f( 1.0f, 1.0f,-1.0f);			
			gl.glVertex3f( 1.0f, 1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f, 1.0f);			
			gl.glVertex3f( 1.0f,-1.0f,-1.0f);			
		gl.glEnd();	
	}
	
	public void terminate()
	{
		new Thread() {
			public void run() {
				panel.stopAnimation();
			}
		}.start();
		dispose();
	}
}
